/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.mixin.common;

import io.github.gaming32.bingo.ext.ItemEntityExt;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity {
    @Unique
    @Nullable
    protected Vec3 bingo$startSneakingPos;

    @Shadow
    public abstract Vec3 position();

    @Shadow
    public abstract boolean hasPose(Pose var1);

    @Inject(method={"setPose"}, at={@At(value="HEAD")})
    private void trackSneakingStart(Pose pose, CallbackInfo ci) {
        if (pose == Pose.CROUCHING) {
            if (!this.hasPose(Pose.CROUCHING)) {
                this.bingo$startSneakingPos = this.position();
            }
        } else {
            this.bingo$startSneakingPos = null;
        }
    }

    @Inject(method={"spawnAtLocation(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;F)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="RETURN")})
    private void setDroppedBy(ServerLevel serverLevel, ItemStack itemStack, float f, CallbackInfoReturnable<ItemEntity> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof ItemEntityExt) {
            ItemEntityExt itemEntity = (ItemEntityExt)object;
            itemEntity.bingo$setDroppedBy((Entity)this);
        }
    }

    @Inject(method={"awardKillScore"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancements/critereon/KilledTrigger;trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;)V", shift=At.Shift.AFTER)})
    private void customTrigger(Entity killed, DamageSource source, CallbackInfo ci) {
        BingoTriggers.ENTITY_KILLED_PLAYER.get().trigger((ServerPlayer)killed, (Entity)this, source);
    }
}

