/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.mixin.common;

import io.github.gaming32.bingo.ext.LeashFenceKnotEntityExt;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LeashFenceKnotEntity.class})
public abstract class MixinLeashFenceKnotEntity
extends BlockAttachedEntity
implements LeashFenceKnotEntityExt {
    @Unique
    private Player bingo$cachedOwner;
    @Unique
    private UUID bingo$ownerUuid;

    protected MixinLeashFenceKnotEntity(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Nullable
    public Player bingo$getOwner() {
        if (this.bingo$cachedOwner == null) {
            UUID uuid = this.bingo$ownerUuid;
            if (uuid == null) {
                return null;
            }
            Player player = this.level().getPlayerByUUID(uuid);
            if (player == null) {
                return null;
            }
            this.bingo$cachedOwner = player;
            this.bingo$ownerUuid = null;
            return player;
        }
        return this.bingo$cachedOwner;
    }

    @Override
    public void bingo$setOwner(@Nullable Player player) {
        this.bingo$cachedOwner = player;
        this.bingo$ownerUuid = null;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void writeOwner(ValueOutput output, CallbackInfo ci) {
        UUID ownerUuid;
        if (this.bingo$cachedOwner != null) {
            ownerUuid = this.bingo$cachedOwner.getUUID();
        } else if (this.bingo$ownerUuid != null) {
            ownerUuid = this.bingo$ownerUuid;
        } else {
            return;
        }
        output.store("bingo:owner", UUIDUtil.CODEC, (Object)ownerUuid);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readOwner(ValueInput input, CallbackInfo ci) {
        UUID ownerUuid = input.read("bingo:owner", UUIDUtil.CODEC).orElse(null);
        if (this.bingo$cachedOwner != null && this.bingo$cachedOwner.getUUID().equals(ownerUuid)) {
            return;
        }
        this.bingo$ownerUuid = ownerUuid;
        this.bingo$cachedOwner = null;
    }
}

