/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import io.github.gaming32.bingo.ext.ItemEntityExt;
import io.github.gaming32.bingo.ext.LivingEntityExt;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.util.DamageEntry;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity
implements LivingEntityExt {
    @Unique
    private final Set<DamageEntry> bingo$damageHistory = new HashSet<DamageEntry>();

    public MixinLivingEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"onEquipItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;doesEmitEquipEvent(Lnet/minecraft/world/entity/EquipmentSlot;)Z")})
    private void onEquipItem(EquipmentSlot slot, ItemStack oldItem, ItemStack newItem, CallbackInfo ci) {
        MixinLivingEntity mixinLivingEntity = this;
        if (mixinLivingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)mixinLivingEntity;
            BingoTriggers.EQUIP_ITEM.get().trigger(player, oldItem, newItem, slot);
        }
    }

    @ModifyExpressionValue(method={"hurtServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;applyItemBlocking(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)F")})
    private float captureBlocked(float blockedDamage, @Share(value="blocked") LocalBooleanRef blocked) {
        blocked.set(blockedDamage > 0.0f);
        return blockedDamage;
    }

    @Inject(method={"hurtServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;die(Lnet/minecraft/world/damagesource/DamageSource;)V")})
    private void onDeathFromDamageSource(ServerLevel serverLevel, DamageSource damageSource, float taken, CallbackInfoReturnable<Boolean> cir, @Local(ordinal=1) float dealt, @Share(value="blocked") LocalBooleanRef blocked) {
        BingoTriggers.ENTITY_DIE_NEAR_PLAYER.get().trigger((LivingEntity)this, damageSource, dealt, taken, blocked.get());
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void onAddAdditionalSaveData(ValueOutput output, CallbackInfo ci) {
        if (!this.bingo$damageHistory.isEmpty()) {
            ValueOutput.TypedOutputList outputList = output.list("bingo:damage_history", DamageEntry.CODEC);
            this.bingo$damageHistory.forEach(arg_0 -> ((ValueOutput.TypedOutputList)outputList).add(arg_0));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void onReadAdditionalSaveData(ValueInput input, CallbackInfo ci) {
        this.bingo$damageHistory.clear();
        input.listOrEmpty("bingo:damage_history", DamageEntry.CODEC).forEach(this.bingo$damageHistory::add);
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="RETURN")})
    private void setDroppedBy(ItemStack droppedItem, boolean dropAround, boolean includeThrowerName, CallbackInfoReturnable<ItemEntity> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof ItemEntityExt) {
            ItemEntityExt itemEntity = (ItemEntityExt)object;
            itemEntity.bingo$setDroppedBy(this);
        }
    }

    @Override
    public void bingo$recordDamage(DamageSource source) {
        this.bingo$damageHistory.add(new DamageEntry(Optional.ofNullable(source.getEntity()).map(Entity::getType), Optional.ofNullable(source.getDirectEntity()).map(Entity::getType), (Holder<DamageType>)source.typeHolder()));
    }

    @Override
    public boolean bingo$hasOnlyBeenDamagedBy(Predicate<DamageEntry> damageEntryPredicate) {
        return this.bingo$damageHistory.stream().allMatch(damageEntryPredicate);
    }
}

