/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.mixin.common;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.ext.ServerPlayerExt;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.mixin.common.MixinEntity;
import io.github.gaming32.bingo.network.messages.s2c.ResyncStatesPayload;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayer
extends MixinEntity
implements ServerPlayerExt {
    @Shadow
    @Final
    public ServerPlayerGameMode gameMode;
    @Shadow
    @Final
    private MinecraftServer server;
    @Unique
    private boolean bingo$advancementsNeedClearing;

    @Inject(method={"doTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/game/ClientboundSetExperiencePacket;<init>(FII)V")})
    private void experienceChanged(CallbackInfo ci) {
        BingoTriggers.EXPERIENCE_CHANGED.get().trigger((ServerPlayer)this);
    }

    @Inject(method={"onItemPickup"}, at={@At(value="TAIL")})
    private void itemPickedUpTrigger(ItemEntity itemEntity, CallbackInfo ci) {
        BingoTriggers.ITEM_PICKED_UP.get().trigger((ServerPlayer)this, itemEntity);
    }

    @Inject(method={"awardKillScore"}, at={@At(value="HEAD")})
    private void killSelfTrigger(Entity killed, DamageSource source, CallbackInfo ci) {
        if (killed == this) {
            BingoTriggers.KILL_SELF.get().trigger((ServerPlayer)killed, source);
        }
    }

    @Inject(method={"die"}, at={@At(value="RETURN")})
    private void deathTrigger(DamageSource damageSource, CallbackInfo ci) {
        BingoTriggers.DEATH.get().trigger((ServerPlayer)this, damageSource);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="FIELD", target="Lnet/minecraft/stats/Stats;CROUCH_ONE_CM:Lnet/minecraft/resources/ResourceLocation;")})
    private void sneakingTrigger(double distanceX, double distanceY, double distanceZ, CallbackInfo ci) {
        MixinServerPlayer mixinServerPlayer = this;
        if (mixinServerPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)mixinServerPlayer;
            if (this.bingo$startSneakingPos == null) {
                Bingo.LOGGER.warn("bingo$startSneakingPos was null but player was sneaking");
            } else {
                BingoTriggers.CROUCH.get().trigger(serverPlayer, this.bingo$startSneakingPos);
            }
        }
    }

    @WrapMethod(method={"setGameMode"})
    private boolean onSetGameMode(GameType newMode, Operation<Boolean> original) {
        GameType oldMode = this.gameMode.getGameModeForPlayer();
        if (!((Boolean)original.call(new Object[]{newMode})).booleanValue()) {
            return false;
        }
        BingoGame game = ((MinecraftServerExt)this.server).bingo$getGame();
        if (game != null && (newMode == GameType.SPECTATOR || oldMode == GameType.SPECTATOR)) {
            ServerPlayer player = (ServerPlayer)this;
            BingoBoard.Teams team = game.getTeam(player);
            new ResyncStatesPayload(game.obfuscateTeam(team, (Player)player)).sendTo(player);
        }
        return true;
    }

    @Override
    public void bingo$markAdvancementsNeedClearing() {
        this.bingo$advancementsNeedClearing = true;
    }

    @Override
    public boolean bingo$clearAdvancementsNeedClearing() {
        boolean result = this.bingo$advancementsNeedClearing;
        this.bingo$advancementsNeedClearing = false;
        return result;
    }

    @Override
    public void bingo$copyAdvancementsNeedClearingTo(ServerPlayer toPlayer) {
        ((MixinServerPlayer)((ServerPlayerExt)toPlayer)).bingo$advancementsNeedClearing = this.bingo$advancementsNeedClearing;
    }
}

