/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.neoforge;

import io.github.gaming32.bingo.network.BingoNetworking;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.Nullable;

public final class BingoNetworkingImpl
extends BingoNetworking {
    private final IEventBus modEventBus;

    BingoNetworkingImpl(IEventBus modEventBus) {
        this.modEventBus = modEventBus;
    }

    @Override
    public void onRegister(Consumer<BingoNetworking.Registrar> handler) {
        this.modEventBus.addListener(RegisterPayloadHandlersEvent.class, event -> handler.accept(new RegistrarImpl(event.registrar("bingo").versioned(Integer.toString(12)).optional())));
    }

    @Override
    public void sendToServer(CustomPacketPayload payload) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Not connected!");
        }
        connection.send(payload);
    }

    @Override
    public void sendTo(ServerPlayer player, CustomPacketPayload payload) {
        player.connection.send(payload);
    }

    @Override
    public boolean canServerReceive(CustomPacketPayload.Type<?> type) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            return false;
        }
        return connection.hasChannel(type);
    }

    @Override
    public boolean canPlayerReceive(ServerPlayer player, CustomPacketPayload.Type<?> type) {
        return player.connection.hasChannel(type);
    }

    @Override
    protected void finishTask(ServerConfigurationPacketListenerImpl packetListener, ConfigurationTask.Type type) {
        packetListener.finishCurrentTask(type);
    }

    private static BingoNetworking.Context convertContext(IPayloadContext neoforge) {
        return new BingoNetworking.Context(neoforge.protocol() == ConnectionProtocol.PLAY ? neoforge.player() : null, arg_0 -> ((IPayloadContext)neoforge).reply(arg_0), (PacketListener)neoforge.listener(), neoforge.flow());
    }

    public static final class RegistrarImpl
    extends BingoNetworking.Registrar {
        private final PayloadRegistrar inner;

        private RegistrarImpl(PayloadRegistrar inner) {
            this.inner = inner;
        }

        @Override
        public <P extends CustomPacketPayload> void register(ConnectionProtocol protocol, @Nullable PacketFlow flow, CustomPacketPayload.Type<P> type, StreamCodec<? super RegistryFriendlyByteBuf, P> codec, BiConsumer<P, BingoNetworking.Context> handler) {
            IPayloadHandler neoHandler = (payload, context) -> handler.accept(payload, BingoNetworkingImpl.convertContext(context));
            block0 : switch (protocol) {
                case PLAY: {
                    PacketFlow packetFlow = flow;
                    int n = 0;
                    switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CLIENTBOUND", "SERVERBOUND"}, (PacketFlow)packetFlow, n)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case -1: {
                            this.inner.playBidirectional(type, codec, neoHandler, neoHandler);
                            break block0;
                        }
                        case 0: {
                            this.inner.playToClient(type, codec, neoHandler);
                            break block0;
                        }
                        case 1: 
                    }
                    this.inner.playToServer(type, codec, neoHandler);
                    break;
                }
                case CONFIGURATION: {
                    StreamCodec<? super RegistryFriendlyByteBuf, P> castedCodec = codec;
                    PacketFlow packetFlow = flow;
                    int n = 0;
                    switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CLIENTBOUND", "SERVERBOUND"}, (PacketFlow)packetFlow, n)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case -1: {
                            this.inner.configurationBidirectional(type, castedCodec, neoHandler, neoHandler);
                            break block0;
                        }
                        case 0: {
                            this.inner.configurationToClient(type, castedCodec, neoHandler);
                            break block0;
                        }
                        case 1: 
                    }
                    this.inner.configurationToServer(type, castedCodec, neoHandler);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot register for connection state: " + String.valueOf(protocol));
                }
            }
        }
    }
}

