/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import io.github.gaming32.bingo.neoforge.BingoNetworkingImpl;
import io.github.gaming32.bingo.neoforge.NeoForgeConfigurationTaskRegistrar;
import io.github.gaming32.bingo.neoforge.registry.NeoForgeDeferredRegister;
import io.github.gaming32.bingo.network.BingoNetworking;
import io.github.gaming32.bingo.platform.BingoPlatform;
import io.github.gaming32.bingo.platform.event.ClientEvents;
import io.github.gaming32.bingo.platform.event.Event;
import io.github.gaming32.bingo.platform.registrar.ClientTooltipRegistrar;
import io.github.gaming32.bingo.platform.registrar.DataReloadListenerRegistrar;
import io.github.gaming32.bingo.platform.registrar.DatapackRegistryRegistrar;
import io.github.gaming32.bingo.platform.registrar.KeyMappingBuilder;
import io.github.gaming32.bingo.platform.registrar.KeyMappingBuilderImpl;
import io.github.gaming32.bingo.platform.registrar.PictureInPictureRendererRegistrar;
import io.github.gaming32.bingo.platform.registry.DeferredRegister;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterPictureInPictureRenderersEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgePlatform
extends BingoPlatform {
    private final IEventBus modEventBus;
    private final BingoNetworking networking;

    public NeoForgePlatform(IEventBus modEventBus) {
        this.modEventBus = modEventBus;
        this.networking = new BingoNetworkingImpl(modEventBus);
        this.registerEvents();
    }

    @Override
    public BingoNetworking getNetworking() {
        return this.networking;
    }

    @Override
    public boolean isClient() {
        return FMLEnvironment.getDist().isClient();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isModLoaded(String id) {
        return ModList.get().isLoaded(id);
    }

    @Override
    public void registerClientTooltips(Consumer<ClientTooltipRegistrar> handler) {
        this.modEventBus.addListener(event -> handler.accept((arg_0, arg_1) -> ((RegisterClientTooltipComponentFactoriesEvent)event).register(arg_0, arg_1)));
    }

    @Override
    public void registerPictureInPictureRenderers(Consumer<PictureInPictureRendererRegistrar> handler) {
        this.modEventBus.addListener(event -> handler.accept((arg_0, arg_1) -> ((RegisterPictureInPictureRenderersEvent)event).register(arg_0, arg_1)));
    }

    @Override
    public void registerKeyMappings(Consumer<KeyMappingBuilder> handler) {
        final ArrayList categories = new ArrayList();
        KeyMappingBuilderImpl builder = new KeyMappingBuilderImpl(this){

            @Override
            public KeyMappingBuilder.KeyMappingExt register(Consumer<Minecraft> action) {
                KeyMappingBuilder.KeyMappingExt mapping = super.register(action);
                mapping.mapping().setKeyConflictContext(NeoForgePlatform.convertConflictContext(mapping.conflictContext()));
                return mapping;
            }

            @Override
            public KeyMapping.Category registerCategory(ResourceLocation id) {
                KeyMapping.Category category = new KeyMapping.Category(id);
                categories.add(category);
                return category;
            }
        };
        handler.accept(builder);
        this.modEventBus.addListener(event -> {
            builder.registerAll(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
            for (KeyMapping.Category category : categories) {
                event.registerCategory(category);
            }
        });
        NeoForge.EVENT_BUS.addListener(event -> builder.handleAll(Minecraft.getInstance()));
    }

    private static IKeyConflictContext convertConflictContext(KeyMappingBuilder.ConflictContext conflictContext) {
        return switch (conflictContext) {
            default -> throw new MatchException(null, null);
            case KeyMappingBuilder.ConflictContext.UNIVERSAL -> KeyConflictContext.UNIVERSAL;
            case KeyMappingBuilder.ConflictContext.GUI -> KeyConflictContext.GUI;
            case KeyMappingBuilder.ConflictContext.IN_GAME -> KeyConflictContext.IN_GAME;
            case KeyMappingBuilder.ConflictContext.NEVER -> BingoConflictContext.NEVER;
        };
    }

    @Override
    public void registerDataReloadListeners(Consumer<DataReloadListenerRegistrar> handler) {
        NeoForge.EVENT_BUS.addListener(event -> handler.accept((id, listener, dependencies) -> {
            event.addListener(id, (PreparableReloadListener)listener.apply(event.getServerResources().getRegistryLookup()));
            for (ResourceLocation dependency : dependencies) {
                event.addDependency(dependency, id);
            }
        }));
    }

    @Override
    public void registerDatapackRegistries(Consumer<DatapackRegistryRegistrar> handler) {
        this.modEventBus.addListener(event -> handler.accept(new DatapackRegistryRegistrar(){
            final /* synthetic */ DataPackRegistryEvent.NewRegistry val$event;
            {
                this.val$event = newRegistry;
            }

            @Override
            public <T> void unsynced(ResourceKey<Registry<T>> registryKey, Codec<T> codec) {
                this.val$event.dataPackRegistry(registryKey, codec);
            }

            @Override
            public <T> void synced(ResourceKey<Registry<T>> registryKey, Codec<T> codec, @Nullable Codec<T> networkCodec) {
                this.val$event.dataPackRegistry(registryKey, codec, networkCodec);
            }
        }));
    }

    @Override
    public <T> DeferredRegister<T> createDeferredRegister(Registry<T> registry) {
        NeoForgeDeferredRegister<T> register = new NeoForgeDeferredRegister<T>(registry);
        register.getDeferredRegister().register(this.modEventBus);
        return register;
    }

    @Override
    public <T> DeferredRegister<T> buildDeferredRegister(io.github.gaming32.bingo.platform.registry.RegistryBuilder<T> builder) {
        Registry registry = new RegistryBuilder(builder.getKey()).sync(builder.isSynced()).defaultKey(builder.getDefaultId()).create();
        this.modEventBus.addListener(event -> event.register(registry));
        return this.createDeferredRegister(registry);
    }

    private void registerEvents() {
        IEventBus bus = NeoForge.EVENT_BUS;
        Event.REGISTER_COMMANDS.setRegistrar(handler -> bus.addListener(event -> handler.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection())));
        Event.REGISTER_CONFIGURATION_TASKS.setRegistrar(handler -> this.modEventBus.addListener(event -> handler.accept(new NeoForgeConfigurationTaskRegistrar((RegisterConfigurationTasksEvent)event))));
        Event.PLAYER_JOIN.setRegistrar(handler -> bus.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                handler.accept(serverPlayer);
            }
        }));
        Event.PLAYER_QUIT.setRegistrar(handler -> bus.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                handler.accept(serverPlayer);
            }
        }));
        Event.COPY_PLAYER.setRegistrar(handler -> bus.addListener(event -> handler.accept((ServerPlayer)event.getOriginal(), (ServerPlayer)event.getEntity())));
        Event.SERVER_STARTED.setRegistrar(handler -> bus.addListener(event -> handler.accept(event.getServer())));
        Event.SERVER_STOPPING.setRegistrar(handler -> bus.addListener(event -> handler.accept(event.getServer())));
        Event.SERVER_STOPPED.setRegistrar(handler -> bus.addListener(event -> handler.accept(event.getServer())));
        Event.RIGHT_CLICK_ITEM.setRegistrar(handler -> bus.addListener(event -> handler.accept(event.getEntity(), event.getHand())));
        Event.SERVER_EXPLOSION_START.setRegistrar(handler -> bus.addListener(event -> handler.accept((ServerLevel)event.getLevel(), event.getExplosion())));
        Event.SERVER_TICK_END.setRegistrar(handler -> bus.addListener(event -> handler.accept(event.getServer())));
        if (this.isClient()) {
            ClientEvents.KEY_RELEASED_PRE.setRegistrar(handler -> bus.addListener(event -> {
                if (handler.onKeyReleased(event.getScreen(), event.getKeyEvent())) {
                    event.setCanceled(true);
                }
            }));
            ClientEvents.MOUSE_RELEASED_PRE.setRegistrar(handler -> bus.addListener(event -> {
                if (handler.onMouseReleased(event.getScreen(), event.getMouseButtonEvent())) {
                    event.setCanceled(true);
                }
            }));
            ClientEvents.PLAYER_QUIT.setRegistrar(handler -> bus.addListener(event -> handler.accept(event.getPlayer())));
            ClientEvents.CLIENT_TICK_START.setRegistrar(handler -> bus.addListener(event -> handler.accept(Minecraft.getInstance())));
            ClientEvents.CLIENT_TICK_END.setRegistrar(handler -> bus.addListener(event -> handler.accept(Minecraft.getInstance())));
        }
    }

    private static enum BingoConflictContext implements IKeyConflictContext
    {
        NEVER{

            public boolean isActive() {
                return false;
            }

            public boolean conflicts(@NotNull IKeyConflictContext iKeyConflictContext) {
                return false;
            }
        };

    }
}

