/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.neoforge.registry;

import io.github.gaming32.bingo.neoforge.registry.NeoForgeRegistryValue;
import io.github.gaming32.bingo.platform.registry.RegistryValue;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class NeoForgeDeferredRegister<T>
implements io.github.gaming32.bingo.platform.registry.DeferredRegister<T> {
    private final Registry<T> registry;
    private final DeferredRegister<T> deferredRegister;

    public NeoForgeDeferredRegister(Registry<T> registry) {
        this.registry = registry;
        this.deferredRegister = DeferredRegister.create(registry, (String)"bingo");
    }

    @Override
    public Registry<T> registry() {
        return this.registry;
    }

    @Override
    public ResourceKey<? extends Registry<T>> registryKey() {
        return this.registry.key();
    }

    @Override
    public <S extends T> RegistryValue<S> register(ResourceLocation location, Supplier<S> value) {
        if (!location.getNamespace().equals("bingo")) {
            throw new IllegalArgumentException("Can only use NeoForgeDeferredRegister with bingo namespace");
        }
        return new NeoForgeRegistryValue(this.deferredRegister.register(location.getPath(), value));
    }

    public DeferredRegister<T> getDeferredRegister() {
        return this.deferredRegister;
    }
}

