/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.network;

import io.github.gaming32.bingo.network.AbstractCustomPayload;
import io.github.gaming32.bingo.platform.BingoPlatform;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class BingoNetworking {
    public static final int PROTOCOL_VERSION = 12;

    public static BingoNetworking instance() {
        return BingoPlatform.platform.getNetworking();
    }

    public abstract void onRegister(Consumer<Registrar> var1);

    public abstract void sendToServer(CustomPacketPayload var1);

    public abstract void sendTo(ServerPlayer var1, CustomPacketPayload var2);

    public void sendTo(Iterable<ServerPlayer> players, CustomPacketPayload payload) {
        for (ServerPlayer player : players) {
            this.sendTo(player, payload);
        }
    }

    public abstract boolean canServerReceive(CustomPacketPayload.Type<?> var1);

    public abstract boolean canPlayerReceive(ServerPlayer var1, CustomPacketPayload.Type<?> var2);

    protected abstract void finishTask(ServerConfigurationPacketListenerImpl var1, ConfigurationTask.Type var2);

    public final void finishTask(Context context, ConfigurationTask.Type type) {
        PacketListener packetListener = context.packetListener;
        if (!(packetListener instanceof ServerConfigurationPacketListenerImpl)) {
            throw new IllegalStateException("finishTask can only be called during the configuration phase");
        }
        ServerConfigurationPacketListenerImpl packetListener2 = (ServerConfigurationPacketListenerImpl)packetListener;
        this.finishTask(packetListener2, type);
    }

    public static final class Context {
        @Nullable
        private final Player player;
        private final Consumer<CustomPacketPayload> reply;
        private final PacketListener packetListener;
        private final PacketFlow flow;

        public Context(@Nullable Player player, Consumer<CustomPacketPayload> reply, PacketListener packetListener, PacketFlow flow) {
            this.player = player;
            this.reply = reply;
            this.packetListener = packetListener;
            this.flow = flow;
        }

        @Nullable
        public Player player() {
            return this.player;
        }

        public void reply(CustomPacketPayload payload) {
            this.reply.accept(payload);
        }

        public PacketFlow flow() {
            return this.flow;
        }

        public Level level() {
            if (this.player == null) {
                return null;
            }
            return this.player.level();
        }

        public void disconnect(Component reason) {
            PacketListener packetListener = this.packetListener;
            if (packetListener instanceof ServerCommonPacketListenerImpl) {
                ServerCommonPacketListenerImpl serverListener = (ServerCommonPacketListenerImpl)packetListener;
                serverListener.disconnect(reason);
            } else if (!BingoPlatform.platform.isClient() || !ClientDisconnecter.disconnect(this.packetListener, reason)) {
                throw new IllegalStateException("Cannot disconnect with listener " + this.packetListener.getClass().getName());
            }
        }

        private static final class ClientDisconnecter {
            private ClientDisconnecter() {
            }

            static boolean disconnect(PacketListener packetListener, Component reason) {
                if (packetListener instanceof ClientCommonPacketListenerImpl) {
                    ClientCommonPacketListenerImpl clientListener = (ClientCommonPacketListenerImpl)packetListener;
                    clientListener.handleDisconnect(new ClientboundDisconnectPacket(reason));
                    return true;
                }
                return false;
            }
        }
    }

    public static abstract class Registrar {
        public abstract <P extends CustomPacketPayload> void register(ConnectionProtocol var1, @Nullable PacketFlow var2, CustomPacketPayload.Type<P> var3, StreamCodec<? super RegistryFriendlyByteBuf, P> var4, BiConsumer<P, Context> var5);

        public <P extends AbstractCustomPayload> void register(@Nullable PacketFlow flow, CustomPacketPayload.Type<P> type, StreamCodec<? super RegistryFriendlyByteBuf, P> codec) {
            this.register(ConnectionProtocol.PLAY, flow, type, codec, AbstractCustomPayload::handle);
        }
    }
}

