/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.network;

import io.github.gaming32.bingo.network.messages.both.ManualHighlightPayload;
import io.github.gaming32.bingo.network.messages.s2c.InitBoardPayload;
import io.github.gaming32.bingo.network.messages.s2c.ResyncStatesPayload;
import io.github.gaming32.bingo.network.messages.s2c.SyncTeamPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateProgressPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateStatePayload;
import io.github.gaming32.bingo.platform.BingoPlatform;
import net.minecraft.world.level.Level;

public interface ClientPayloadHandler {
    public void handleInitBoard(InitBoardPayload var1, Level var2);

    public void handleRemoveBoard();

    public void handleResyncStates(ResyncStatesPayload var1);

    public void handleSyncTeam(SyncTeamPayload var1);

    public void handleUpdateProgress(UpdateProgressPayload var1);

    public void handleUpdateState(UpdateStatePayload var1);

    public void handleManualHighlight(ManualHighlightPayload var1);

    public static ClientPayloadHandler get() {
        if (Holder.instance == null) {
            if (BingoPlatform.platform.isClient()) {
                throw new IllegalStateException("ClientPayloadHandler not initialized yet!");
            }
            throw new IllegalStateException("Cannot call ClientPayloadHandler.get() on server!");
        }
        return Holder.instance;
    }

    public static void init(ClientPayloadHandler instance) {
        if (Holder.instance != null) {
            throw new IllegalStateException("Cannot call ClientPayloadHandler.init() more than once.");
        }
        if (!BingoPlatform.platform.isClient()) {
            throw new IllegalStateException("Cannot call ClientPayloadHandler.init() on server.");
        }
        Holder.instance = instance;
    }

    public static class Holder {
        private static ClientPayloadHandler instance;
    }
}

