/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.network.messages.both;

import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.network.AbstractCustomPayload;
import io.github.gaming32.bingo.network.BingoNetworking;
import io.github.gaming32.bingo.network.ClientPayloadHandler;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public record ManualHighlightPayload(int slot, int value, int modCount) implements AbstractCustomPayload
{
    public static final CustomPacketPayload.Type<ManualHighlightPayload> TYPE = AbstractCustomPayload.type("manual_highlight");
    public static final StreamCodec<RegistryFriendlyByteBuf, ManualHighlightPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ManualHighlightPayload::slot, (StreamCodec)ByteBufCodecs.VAR_INT, ManualHighlightPayload::value, (StreamCodec)ByteBufCodecs.VAR_INT, ManualHighlightPayload::modCount, ManualHighlightPayload::new);

    @NotNull
    public CustomPacketPayload.Type<ManualHighlightPayload> type() {
        return TYPE;
    }

    @Override
    public void handle(BingoNetworking.Context context) {
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            ClientPayloadHandler.get().handleManualHighlight(this);
        } else {
            if (this.value < 0 || this.value > 3) {
                return;
            }
            ServerPlayer player = (ServerPlayer)context.player();
            assert (player != null);
            MinecraftServer server = player.level().getServer();
            BingoGame game = ((MinecraftServerExt)server).bingo$getGame();
            if (game == null) {
                return;
            }
            if (this.slot < 0 || this.slot >= game.getBoard().getShape().getGoalCount(game.getBoard().getSize())) {
                return;
            }
            BingoBoard.Teams team = game.getTeam(player);
            if (!team.one()) {
                return;
            }
            if (this.modCount != game.getBoard().getManualHighlightModCount(team)) {
                return;
            }
            game.getBoard().setTeamManualHighlight(server, game, team, this.slot, this.value == 0 ? null : Integer.valueOf(this.value - 1), player);
        }
    }
}

