/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.network.messages.configuration;

import io.github.gaming32.bingo.network.AbstractCustomPayload;
import io.github.gaming32.bingo.network.BingoNetworking;
import io.github.gaming32.bingo.network.messages.configuration.ProtocolVersionConfigurationTask;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public record ProtocolVersionPayload(int protocolVersion) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ProtocolVersionPayload> TYPE = AbstractCustomPayload.type("version");
    public static final StreamCodec<ByteBuf, ProtocolVersionPayload> CODEC = ByteBufCodecs.VAR_INT.map(ProtocolVersionPayload::new, ProtocolVersionPayload::protocolVersion);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handleClientbound(BingoNetworking.Context context) {
        context.reply(new ProtocolVersionPayload(12));
    }

    public void handleServerbound(BingoNetworking.Context context) {
        BingoNetworking.instance().finishTask(context, ProtocolVersionConfigurationTask.TYPE);
        if (this.protocolVersion != 12) {
            if (this.protocolVersion < 12) {
                context.disconnect((Component)Component.translatable((String)"bingo.outdated_client", (Object[])new Object[]{this.protocolVersion, 12}));
            } else {
                context.disconnect((Component)Component.translatable((String)"bingo.outdated_server", (Object[])new Object[]{12, this.protocolVersion}));
            }
        }
    }
}

