/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.platform.registrar;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.gaming32.bingo.platform.registrar.KeyMappingBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;

public abstract class KeyMappingBuilderImpl
implements KeyMappingBuilder {
    private final List<KeyMappingBuilder.KeyMappingExt> mappings = new ArrayList<KeyMappingBuilder.KeyMappingExt>();
    private String name;
    private KeyMapping.Category category;
    private InputConstants.Type keyType;
    private int keyCode;
    private KeyMappingBuilder.ConflictContext conflictContext;

    public KeyMappingBuilderImpl() {
        this.reset();
    }

    private void reset() {
        this.name = null;
        this.keyType = InputConstants.Type.KEYSYM;
        this.keyCode = -1;
        this.category = null;
        this.conflictContext = KeyMappingBuilder.ConflictContext.UNIVERSAL;
    }

    @Override
    public KeyMappingBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public KeyMappingBuilder category(KeyMapping.Category category) {
        this.category = category;
        return this;
    }

    @Override
    public KeyMappingBuilder keyType(InputConstants.Type type) {
        this.keyType = type;
        return this;
    }

    @Override
    public KeyMappingBuilder keyCode(int keyCode) {
        this.keyCode = keyCode;
        return this;
    }

    @Override
    public KeyMappingBuilder conflictContext(KeyMappingBuilder.ConflictContext conflictContext) {
        this.conflictContext = conflictContext;
        return this;
    }

    @Override
    public KeyMappingBuilder.KeyMappingExt register(Consumer<Minecraft> action) {
        if (this.name == null) {
            throw new IllegalStateException("KeyMappingBuilder.name not set");
        }
        if (this.category == null) {
            throw new IllegalStateException("KeyMappingBuilder.category not set");
        }
        if (action == null) {
            throw new IllegalStateException("KeyMappingBuilder.action not set");
        }
        KeyMappingBuilder.KeyMappingExt result = new KeyMappingBuilder.KeyMappingExt(new KeyMapping(this.name, this.keyType, this.keyCode, this.category), this.conflictContext, action);
        this.reset();
        this.mappings.add(result);
        return result;
    }

    public void registerAll(Consumer<KeyMapping> consumer) {
        this.mappings.stream().map(KeyMappingBuilder.KeyMappingExt::mapping).forEach(consumer);
    }

    public void handleAll(Minecraft minecraft) {
        for (KeyMappingBuilder.KeyMappingExt mapping : this.mappings) {
            while (mapping.mapping().consumeClick()) {
                mapping.action().accept(minecraft);
            }
        }
    }
}

