/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.subpredicates;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.game.BingoGame;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BingoPlayerPredicate(List<PlayerPredicate.StatMatcher<?>> relativeStats) implements EntitySubPredicate
{
    public static final MapCodec<BingoPlayerPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PlayerPredicate.StatMatcher.CODEC.listOf().optionalFieldOf("relative_stats", List.of()).forGetter(BingoPlayerPredicate::relativeStats)).apply((Applicative)instance, BingoPlayerPredicate::new));

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BingoGame game = ((MinecraftServerExt)level.getServer()).bingo$getGame();
        if (game != null) {
            Object2IntMap<Stat<?>> baseStats = game.getBaseStats((Player)player);
            ServerStatsCounter currentStats = player.getStats();
            for (PlayerPredicate.StatMatcher<?> matcher : this.relativeStats) {
                Stat stat = (Stat)matcher.stat().get();
                int currentValue = currentStats.getValue(stat);
                int value = currentValue - baseStats.getOrDefault((Object)stat, currentValue);
                if (matcher.range().matches(value)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public MapCodec<? extends EntitySubPredicate> codec() {
        return CODEC;
    }

    public static class Builder {
        private final ImmutableList.Builder<PlayerPredicate.StatMatcher<?>> relativeStats = ImmutableList.builder();

        public static Builder player() {
            return new Builder();
        }

        public <T> Builder addRelativeStat(StatType<T> type, Holder.Reference<T> value, MinMaxBounds.Ints range) {
            this.relativeStats.add((Object)new PlayerPredicate.StatMatcher(type, value, range));
            return this;
        }

        public BingoPlayerPredicate build() {
            return new BingoPlayerPredicate((List<PlayerPredicate.StatMatcher<?>>)this.relativeStats.build());
        }
    }
}

