/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.subpredicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.ext.ItemEntityExt;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ItemEntityPredicate(Optional<ItemPredicate> item, MinMaxBounds.Ints age, Optional<EntityPredicate> droppedBy) implements EntitySubPredicate
{
    public static final MapCodec<ItemEntityPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(ItemEntityPredicate::item), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("age", (Object)MinMaxBounds.Ints.ANY).forGetter(ItemEntityPredicate::age), (App)EntityPredicate.CODEC.optionalFieldOf("dropped_by").forGetter(ItemEntityPredicate::droppedBy)).apply((Applicative)instance, ItemEntityPredicate::new));

    public static ItemEntityPredicate item(ItemPredicate item) {
        return new ItemEntityPredicate(Optional.of(item), MinMaxBounds.Ints.ANY, Optional.empty());
    }

    public static ItemEntityPredicate droppedBy(Optional<ItemPredicate> item, Optional<EntityPredicate> droppedBy) {
        return new ItemEntityPredicate(item, MinMaxBounds.Ints.ANY, droppedBy);
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof ItemEntity)) {
            return false;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (this.item.isPresent() && !this.item.get().test(itemEntity.getItem())) {
            return false;
        }
        if (!this.age.matches(itemEntity.getAge())) {
            return false;
        }
        return !this.droppedBy.isPresent() || this.droppedBy.get().matches(level, position, ((ItemEntityExt)itemEntity).bingo$getDroppedBy());
    }

    @NotNull
    public MapCodec<ItemEntityPredicate> codec() {
        return CODEC;
    }
}

