/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.subpredicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PaintingPredicate(MinMaxBounds.Ints width, MinMaxBounds.Ints height, MinMaxBounds.Ints area, Optional<HolderSet<PaintingVariant>> variant) implements EntitySubPredicate
{
    public static final MapCodec<PaintingPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinMaxBounds.Ints.CODEC.optionalFieldOf("width", (Object)MinMaxBounds.Ints.ANY).forGetter(PaintingPredicate::width), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("height", (Object)MinMaxBounds.Ints.ANY).forGetter(PaintingPredicate::height), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("area", (Object)MinMaxBounds.Ints.ANY).forGetter(PaintingPredicate::area), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.PAINTING_VARIANT).optionalFieldOf("variant").forGetter(PaintingPredicate::variant)).apply((Applicative)instance, PaintingPredicate::new));

    @NotNull
    public MapCodec<? extends EntitySubPredicate> codec() {
        return CODEC;
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof Painting)) {
            return false;
        }
        Painting painting = (Painting)entity;
        Holder variantHolder = painting.getVariant();
        PaintingVariant variant = (PaintingVariant)variantHolder.value();
        if (!this.width.matches(variant.width())) {
            return false;
        }
        if (!this.height.matches(variant.height())) {
            return false;
        }
        if (!this.area.matches(variant.area())) {
            return false;
        }
        return !this.variant.isPresent() || this.variant.get().contains(variantHolder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private MinMaxBounds.Ints width = MinMaxBounds.Ints.ANY;
        private MinMaxBounds.Ints height = MinMaxBounds.Ints.ANY;
        private MinMaxBounds.Ints area = MinMaxBounds.Ints.ANY;
        private Optional<HolderSet<PaintingVariant>> variant = Optional.empty();

        private Builder() {
        }

        public Builder width(MinMaxBounds.Ints width) {
            this.width = width;
            return this;
        }

        public Builder height(MinMaxBounds.Ints height) {
            this.height = height;
            return this;
        }

        public Builder area(MinMaxBounds.Ints area) {
            this.area = area;
            return this;
        }

        public Builder variant(HolderSet<PaintingVariant> variant) {
            this.variant = Optional.of(variant);
            return this;
        }

        @SafeVarargs
        public final Builder variant(HolderLookup<PaintingVariant> lookup, ResourceKey<PaintingVariant> ... variants) {
            return this.variant((HolderSet<PaintingVariant>)HolderSet.direct(arg_0 -> lookup.getOrThrow(arg_0), (Object[])variants));
        }

        public Builder variant(HolderLookup<PaintingVariant> lookup, TagKey<PaintingVariant> tag) {
            return this.variant((HolderSet<PaintingVariant>)lookup.getOrThrow(tag));
        }

        public PaintingPredicate build() {
            return new PaintingPredicate(this.width, this.height, this.area, this.variant);
        }
    }
}

