/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.subpredicates.PaintingPredicate;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.util.BingoUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.jetbrains.annotations.NotNull;

public class AdjacentPaintingTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Painting painting) {
        this.trigger(player, instance -> instance.matches(player, painting));
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> placedPainting, Optional<ContextAwarePredicate> adjacentPaintings, MinMaxBounds.Ints count) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("placed_painting").forGetter(TriggerInstance::placedPainting), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("adjacent_paintings").forGetter(TriggerInstance::adjacentPaintings), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("count", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::count)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerPlayer player, Painting painting) {
            if (this.placedPainting.isPresent() && !this.placedPainting.get().matches(EntityPredicate.createContext((ServerPlayer)player, (Entity)painting))) {
                return false;
            }
            ObjectOpenCustomHashSet seenVariants = new ObjectOpenCustomHashSet(BingoUtil.holderStrategy());
            int count = this.countAdjacentPaintings(player, painting, (ObjectSet<Holder<PaintingVariant>>)seenVariants);
            return this.count.matches(count);
        }

        private int countAdjacentPaintings(ServerPlayer player, Painting painting, ObjectSet<Holder<PaintingVariant>> seenVariants) {
            if (!seenVariants.add((Object)painting.getVariant())) {
                return 0;
            }
            int count = 1;
            for (Painting otherPainting : painting.level().getEntitiesOfClass(Painting.class, painting.getBoundingBox().inflate(0.25))) {
                if (otherPainting == painting || !this.adjacentPaintings.isEmpty() && !this.adjacentPaintings.get().matches(EntityPredicate.createContext((ServerPlayer)player, (Entity)otherPainting))) continue;
                count += this.countAdjacentPaintings(player, otherPainting, seenVariants);
            }
            return count;
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            criterionValidator.validateEntity(this.placedPainting, ".placed_painting");
            criterionValidator.validateEntity(this.adjacentPaintings, ".adjacent_paintings");
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private Optional<ContextAwarePredicate> placedPainting = Optional.empty();
        private Optional<ContextAwarePredicate> adjacentPaintings = Optional.empty();
        private MinMaxBounds.Ints count = MinMaxBounds.Ints.ANY;

        private Builder() {
        }

        public Builder player(EntityPredicate player) {
            return this.player(EntityPredicate.wrap((EntityPredicate)player));
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder placedPainting(ContextAwarePredicate placedPainting) {
            this.placedPainting = Optional.of(placedPainting);
            return this;
        }

        public Builder placedPainting(EntityPredicate placedPainting) {
            return this.placedPainting(EntityPredicate.wrap((EntityPredicate)placedPainting));
        }

        public Builder placedPainting(PaintingPredicate placedPainting) {
            return this.placedPainting(EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)placedPainting).build());
        }

        public Builder adjacentPaintings(ContextAwarePredicate adjacentPaintings) {
            this.adjacentPaintings = Optional.of(adjacentPaintings);
            return this;
        }

        public Builder adjacentPaintings(EntityPredicate adjacentPaintings) {
            return this.adjacentPaintings(EntityPredicate.wrap((EntityPredicate)adjacentPaintings));
        }

        public Builder adjacentPaintings(PaintingPredicate adjacentPaintings) {
            return this.adjacentPaintings(EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)adjacentPaintings).build());
        }

        public Builder count(MinMaxBounds.Ints count) {
            this.count = count;
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.ADJACENT_PAINTING.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.placedPainting, this.adjacentPaintings, this.count));
        }
    }
}

