/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;

public class ArrowPressTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(AbstractArrow arrow, BlockPos pos) {
        Entity entity = arrow.getOwner();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        LootContext arrowContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)arrow);
        this.trigger(player, instance -> instance.matches(arrowContext, pos));
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> arrow, Optional<BlockPredicate> buttonOrPlate, Optional<LocationPredicate> location) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("arrow").forGetter(TriggerInstance::arrow), (App)BlockPredicate.CODEC.optionalFieldOf("button_or_plate").forGetter(TriggerInstance::buttonOrPlate), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(LootContext arrow, BlockPos pos) {
            if (this.arrow.isPresent() && !this.arrow.get().matches(arrow)) {
                return false;
            }
            if (this.buttonOrPlate.isPresent() && !this.buttonOrPlate.get().matches(arrow.getLevel(), pos)) {
                return false;
            }
            return !this.location.isPresent() || this.location.get().matches(arrow.getLevel(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            criterionValidator.validateEntity(this.arrow, ".arrow");
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private Optional<ContextAwarePredicate> arrow = Optional.empty();
        private Optional<BlockPredicate> buttonOrPlate = Optional.empty();
        private Optional<LocationPredicate> location = Optional.empty();

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder arrow(ContextAwarePredicate arrow) {
            this.arrow = Optional.ofNullable(arrow);
            return this;
        }

        public Builder arrow(EntityPredicate arrow) {
            this.arrow = EntityPredicate.wrap(Optional.ofNullable(arrow));
            return this;
        }

        public Builder buttonOrPlate(BlockPredicate buttonOrPlate) {
            this.buttonOrPlate = Optional.ofNullable(buttonOrPlate);
            return this;
        }

        public Builder location(LocationPredicate location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.ARROW_PRESS.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.arrow, this.buttonOrPlate, this.location));
        }
    }
}

