/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class BeaconEffectTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, MobEffectInstance newEffect) {
        this.trigger(player, instance -> instance.matches(player, newEffect));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<MobEffectsPredicate> effect, Optional<MobEffectsPredicate> totalEffects) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MobEffectsPredicate.CODEC.optionalFieldOf("effect").forGetter(TriggerInstance::effect), (App)MobEffectsPredicate.CODEC.optionalFieldOf("total_effects").forGetter(TriggerInstance::totalEffects)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> effectApplied(Holder<MobEffect> effect) {
            return BingoTriggers.BEACON_EFFECT.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), MobEffectsPredicate.Builder.effects().and(effect).build(), Optional.empty()));
        }

        public boolean matches(ServerPlayer player, MobEffectInstance newEffect) {
            if (this.effect.isPresent() && !this.effect.get().matches(Map.of(newEffect.getEffect(), newEffect))) {
                return false;
            }
            return !this.totalEffects.isPresent() || this.totalEffects.get().matches((LivingEntity)player);
        }
    }
}

