/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BedRowTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Level level, BlockPos pos) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(level, pos));
    }

    public static Criterion<TriggerInstance> create(int count) {
        return BingoTriggers.BED_ROW.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), count));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, int count) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ExtraCodecs.POSITIVE_INT.fieldOf("count").forGetter(TriggerInstance::count)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(Level level, BlockPos pos) {
            BedBlock bedBlock;
            BlockState offsetState;
            Block block;
            BlockState state = level.getBlockState(pos);
            if (!(state.getBlock() instanceof BedBlock)) {
                return false;
            }
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (state.getValue((Property)BlockStateProperties.BED_PART) == BedPart.HEAD) {
                Block headBlock = state.getBlock();
                state = level.getBlockState(pos = pos.relative(facing.getOpposite()));
                if (state.getBlock() != headBlock || state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) != facing) {
                    return false;
                }
            }
            if (this.count <= 1) {
                return true;
            }
            EnumSet<DyeColor> foundColors = EnumSet.of(((BedBlock)state.getBlock()).getColor());
            BlockPos offsetPos = pos;
            while ((block = (offsetState = level.getBlockState(offsetPos = offsetPos.relative(facing.getClockWise()))).getBlock()) instanceof BedBlock) {
                bedBlock = (BedBlock)block;
                if (state.getValue((Property)BlockStateProperties.BED_PART) != BedPart.FOOT || state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) != facing || !foundColors.add(bedBlock.getColor())) break;
                if (foundColors.size() < this.count) continue;
                return true;
            }
            offsetPos = pos;
            while ((block = (offsetState = level.getBlockState(offsetPos = offsetPos.relative(facing.getCounterClockWise()))).getBlock()) instanceof BedBlock) {
                bedBlock = (BedBlock)block;
                if (state.getValue((Property)BlockStateProperties.BED_PART) != BedPart.FOOT || state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) != facing || !foundColors.add(bedBlock.getColor())) break;
                if (foundColors.size() < this.count) continue;
                return true;
            }
            return false;
        }
    }
}

