/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class BreakBlockTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, BlockPos pos, ItemStack tool) {
        ServerLevel level = player.level();
        BlockState state = level.getBlockState(pos);
        LootParams locationParams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)pos.getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.TOOL, (Object)tool).create(LootContextParamSets.ADVANCEMENT_LOCATION);
        LootContext location = new LootContext.Builder(locationParams).create(Optional.empty());
        this.trigger(player, triggerInstance -> triggerInstance.matches(location));
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> location) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ContextAwarePredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(LootContext location) {
            return this.location.isEmpty() || this.location.get().matches(location);
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            this.location.ifPresent(p -> criterionValidator.validate(p, LootContextParamSets.ADVANCEMENT_LOCATION, ".location"));
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private Optional<ContextAwarePredicate> location = Optional.empty();

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder location(ContextAwarePredicate location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        public Builder location(LootItemCondition ... conditions) {
            return this.location(ContextAwarePredicate.create((LootItemCondition[])conditions));
        }

        public Builder location(LocationPredicate location) {
            return this.location(new LootItemCondition[]{new LocationCheck(Optional.ofNullable(location), BlockPos.ZERO)});
        }

        public Builder block(BlockPredicate.Builder block) {
            return this.location(LocationPredicate.Builder.location().setBlock(block).build());
        }

        public Builder block(HolderGetter<Block> blocks, Block block) {
            return this.block(BlockPredicate.Builder.block().of(blocks, new Block[]{block}));
        }

        public Builder block(HolderGetter<Block> blocks, TagKey<Block> blockTag) {
            return this.block(BlockPredicate.Builder.block().of(blocks, blockTag));
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.BREAK_BLOCK.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.location));
        }
    }
}

