/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;

public class ChickenHatchTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, ThrownEgg projectile, int numChickens) {
        LootContext projectileContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)projectile);
        this.trigger(player, instance -> instance.matches(projectileContext, numChickens));
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> projectile, MinMaxBounds.Ints numChickens) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("projectile").forGetter(TriggerInstance::projectile), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("num_chickens", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::numChickens)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(LootContext projectileContext, int numChickens) {
            if (this.projectile.isPresent() && !this.projectile.get().matches(projectileContext)) {
                return false;
            }
            return this.numChickens.matches(numChickens);
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            criterionValidator.validateEntity(this.projectile, ".projectile");
        }
    }

    public static class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private Optional<ContextAwarePredicate> projectile = Optional.empty();
        private MinMaxBounds.Ints numChickens = MinMaxBounds.Ints.ANY;

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder projectile(EntityPredicate projectile) {
            return this.projectile(EntityPredicate.wrap((EntityPredicate)projectile));
        }

        public Builder projectile(ContextAwarePredicate projectile) {
            this.projectile = Optional.of(projectile);
            return this;
        }

        public Builder numChickens(MinMaxBounds.Ints numChickens) {
            this.numChickens = numChickens;
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.CHICKEN_HATCH.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.projectile, this.numChickens));
        }
    }
}

