/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;

public class CompleteMapTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, MapItemSavedData data) {
        this.trigger(player, instance -> instance.matches(player.level(), data));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints scale, Optional<Boolean> locked, Optional<LocationPredicate> center) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("scale", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::scale), (App)Codec.BOOL.optionalFieldOf("locked").forGetter(TriggerInstance::locked), (App)LocationPredicate.CODEC.optionalFieldOf("center").forGetter(TriggerInstance::center)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> completeMap() {
            return BingoTriggers.COMPLETED_MAP.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), MinMaxBounds.Ints.ANY, Optional.empty(), Optional.empty()));
        }

        public static Criterion<TriggerInstance> completeMap(MinMaxBounds.Ints scale) {
            return BingoTriggers.COMPLETED_MAP.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), scale, Optional.empty(), Optional.empty()));
        }

        public static Criterion<TriggerInstance> completeMap(MinMaxBounds.Ints scale, LocationPredicate center) {
            return BingoTriggers.COMPLETED_MAP.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), scale, Optional.empty(), Optional.of(center)));
        }

        public boolean matches(ServerLevel level, MapItemSavedData data) {
            if (!this.scale.matches((int)data.scale)) {
                return false;
            }
            if (this.locked.isPresent() && data.locked != this.locked.get()) {
                return false;
            }
            if (this.center.isEmpty()) {
                return true;
            }
            ServerLevel centerLevel = level.getServer().getLevel(data.dimension);
            return centerLevel != null && this.center.get().matches(centerLevel, (double)data.centerX, (double)centerLevel.getSeaLevel(), (double)data.centerZ);
        }
    }
}

