/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import org.jetbrains.annotations.NotNull;

public class DeathTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, DamageSource source) {
        this.trigger(player, instance -> instance.matches(player, source));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<DamageSourcePredicate> source) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)DamageSourcePredicate.CODEC.optionalFieldOf("source").forGetter(TriggerInstance::source)).apply((Applicative)instance, TriggerInstance::new));

        public static TriggerInstance death(DamageSourcePredicate source) {
            return new TriggerInstance(Optional.empty(), Optional.ofNullable(source));
        }

        public boolean matches(ServerPlayer player, DamageSource source) {
            return this.source.isEmpty() || this.source.get().matches(player, source);
        }
    }
}

