/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;

public class DestroyVehicleTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, VehicleEntity vehicle, DamageSource destroyingBlow) {
        LootContext vehicleContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)vehicle);
        this.trigger(player, instance -> instance.matches(player, vehicleContext, destroyingBlow));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> vehicle, Optional<DamageSourcePredicate> destroyingBlow) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("vehicle").forGetter(TriggerInstance::vehicle), (App)DamageSourcePredicate.CODEC.optionalFieldOf("destroying_blow").forGetter(TriggerInstance::destroyingBlow)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerPlayer player, LootContext vehicle, DamageSource destroyingBlow) {
            if (this.vehicle.isPresent() && !this.vehicle.get().matches(vehicle)) {
                return false;
            }
            return !this.destroyingBlow.isPresent() || this.destroyingBlow.get().matches(player, destroyingBlow);
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            criterionValidator.validateEntity(this.vehicle, ".vehicle");
        }
    }
}

