/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import org.jetbrains.annotations.NotNull;

public class DifferentPotionsTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Inventory inventory) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.trigger(player, instance -> instance.matches(inventory, progressListener));
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.DIFFERENT_POTIONS.get().trigger(player, inventory));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, int minCount) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ExtraCodecs.POSITIVE_INT.fieldOf("min_count").forGetter(TriggerInstance::minCount)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> differentPotions(int minCount) {
            return BingoTriggers.DIFFERENT_POTIONS.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), minCount));
        }

        public boolean matches(Inventory inventory, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            HashSet discovered = HashSet.newHashSet(this.minCount);
            int l = inventory.getContainerSize();
            for (int i = 0; i < l; ++i) {
                PotionContents potion;
                ItemStack item = inventory.getItem(i);
                if (!(item.getItem() instanceof PotionItem) || (potion = (PotionContents)item.get(DataComponents.POTION_CONTENTS)) == null || potion.potion().isEmpty() || !discovered.add(((Potion)((Holder)potion.potion().get()).value()).name()) || discovered.size() < this.minCount) continue;
                progressListener.update(this, this.minCount, this.minCount);
                return true;
            }
            progressListener.update(this, discovered.size(), this.minCount);
            return false;
        }
    }
}

