/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;

public class DoorOpenedByTargetTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Projectile projectile, BlockPos targetBlock, int targetBlockPower, BlockPos poweredBlock) {
        LootContext projectileContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)projectile);
        this.trigger(player, instance -> instance.matches(projectileContext, targetBlock, targetBlockPower, poweredBlock));
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> projectile, Optional<LocationPredicate> targetBlock, MinMaxBounds.Ints targetBlockPower, Optional<LocationPredicate> door) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("projectile").forGetter(TriggerInstance::projectile), (App)LocationPredicate.CODEC.optionalFieldOf("target_block").forGetter(TriggerInstance::targetBlock), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("target_block_power", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::targetBlockPower), (App)LocationPredicate.CODEC.optionalFieldOf("door").forGetter(TriggerInstance::door)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(LootContext projectile, BlockPos targetBlock, int targetBlockPower, BlockPos door) {
            if (this.projectile.isPresent() && !this.projectile.get().matches(projectile)) {
                return false;
            }
            if (this.targetBlock.isPresent() && !this.targetBlock.get().matches(projectile.getLevel(), (double)targetBlock.getX(), (double)targetBlock.getY(), (double)targetBlock.getZ())) {
                return false;
            }
            if (!this.targetBlockPower.matches(targetBlockPower)) {
                return false;
            }
            return !this.door.isPresent() || this.door.get().matches(projectile.getLevel(), (double)door.getX(), (double)door.getY(), (double)door.getZ());
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            criterionValidator.validateEntity(this.projectile, ".projectile");
        }
    }

    public static class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private Optional<ContextAwarePredicate> projectile = Optional.empty();
        private Optional<LocationPredicate> targetBlock = Optional.empty();
        private MinMaxBounds.Ints targetBlockPower = MinMaxBounds.Ints.ANY;
        private Optional<LocationPredicate> door = Optional.empty();

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder projectile(ContextAwarePredicate projectile) {
            this.projectile = Optional.of(projectile);
            return this;
        }

        public Builder projectile(EntityPredicate.Builder projectile) {
            return this.projectile(EntityPredicate.wrap((EntityPredicate.Builder)projectile));
        }

        public Builder targetBlock(LocationPredicate targetBlock) {
            this.targetBlock = Optional.of(targetBlock);
            return this;
        }

        public Builder targetBlockPower(MinMaxBounds.Ints targetBlockPower) {
            this.targetBlockPower = targetBlockPower;
            return this;
        }

        public Builder door(LocationPredicate door) {
            this.door = Optional.of(door);
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.DOOR_OPENED_BY_TARGET.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.projectile, this.targetBlock, this.targetBlockPower, this.door));
        }
    }
}

