/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class EnchantedItemTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, int levelsSpent, int levelsRequired) {
        this.trigger(player, instance -> instance.matches(levelsSpent, levelsRequired));
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints levelsSpent, MinMaxBounds.Ints requiredLevels) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("levels_spent", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::levelsSpent), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("required_levels", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::requiredLevels)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(int levelsSpent, int levelsRequired) {
            if (!this.levelsSpent.matches(levelsSpent)) {
                return false;
            }
            return this.requiredLevels.matches(levelsRequired);
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private MinMaxBounds.Ints levelsSpent = MinMaxBounds.Ints.ANY;
        private MinMaxBounds.Ints requiredLevels = MinMaxBounds.Ints.ANY;

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder levelsSpent(MinMaxBounds.Ints levelsSpent) {
            this.levelsSpent = levelsSpent;
            return this;
        }

        public Builder requiredLevels(MinMaxBounds.Ints requiredLevels) {
            this.requiredLevels = requiredLevels;
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.ENCHANTED_ITEM.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.levelsSpent, this.requiredLevels));
        }
    }
}

