/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class EntityDieNearPlayerTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void trigger(LivingEntity entity, DamageSource source, float damageDealt, float damageTaken, boolean blocked) {
        List players = entity.level().getEntitiesOfClass(Player.class, entity.getBoundingBox().inflate(32.0));
        for (Player player : players) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.trigger(serverPlayer, triggerInstance -> triggerInstance.matches(serverPlayer, entity, source, damageDealt, damageTaken, blocked));
        }
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> entity, Optional<DamagePredicate> killingBlow, Optional<DistancePredicate> distance) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("entity").forGetter(TriggerInstance::entity), (App)DamagePredicate.CODEC.optionalFieldOf("killing_blow").forGetter(TriggerInstance::killingBlow), (App)DistancePredicate.CODEC.optionalFieldOf("distance").forGetter(TriggerInstance::distance)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerPlayer player, LivingEntity entity, DamageSource source, float damageDealt, float damageTaken, boolean blocked) {
            if (this.entity.isPresent() && !this.entity.get().matches(EntityPredicate.createContext((ServerPlayer)player, (Entity)entity))) {
                return false;
            }
            if (this.killingBlow.isPresent() && !this.killingBlow.get().matches(player, source, damageDealt, damageTaken, blocked)) {
                return false;
            }
            return !this.distance.isPresent() || this.distance.get().matches(player.getX(), player.getY(), player.getZ(), entity.getX(), entity.getY(), entity.getZ());
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            criterionValidator.validateEntity(this.entity, ".entity");
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private Optional<ContextAwarePredicate> entity = Optional.empty();
        private Optional<DamagePredicate> killingBlow = Optional.empty();
        private Optional<DistancePredicate> distance = Optional.empty();

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder entity(ContextAwarePredicate entity) {
            this.entity = Optional.ofNullable(entity);
            return this;
        }

        public Builder entity(EntityPredicate entity) {
            return this.entity(EntityPredicate.wrap((EntityPredicate)entity));
        }

        public Builder killingBlow(DamagePredicate killingBlow) {
            this.killingBlow = Optional.ofNullable(killingBlow);
            return this;
        }

        public Builder distance(DistancePredicate distance) {
            this.distance = Optional.ofNullable(distance);
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.ENTITY_DIE_NEAR_PLAYER.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.entity, this.killingBlow, this.distance));
        }
    }
}

