/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.util.BingoCodecs;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EquipItemTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, ItemStack oldItem, ItemStack newItem, EquipmentSlot slot) {
        this.trigger(player, instance -> instance.matches(oldItem, newItem, slot));
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> oldItem, Optional<ItemPredicate> newItem, Set<EquipmentSlot> slots) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ItemPredicate.CODEC.optionalFieldOf("old_item").forGetter(TriggerInstance::oldItem), (App)ItemPredicate.CODEC.optionalFieldOf("new_item").forGetter(TriggerInstance::newItem), (App)BingoCodecs.enumSetOf(EquipmentSlot.CODEC).optionalFieldOf("slots", (Object)ImmutableSet.copyOf(EnumSet.allOf(EquipmentSlot.class))).forGetter(TriggerInstance::slots)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ItemStack oldItem, ItemStack newItem, EquipmentSlot slot) {
            if (this.oldItem.isPresent() && !this.oldItem.get().test(oldItem)) {
                return false;
            }
            if (this.newItem.isPresent() && !this.newItem.get().test(newItem)) {
                return false;
            }
            return this.slots.contains(slot);
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private Optional<ItemPredicate> oldItem = Optional.empty();
        private Optional<ItemPredicate> newItem = Optional.empty();
        private final Set<EquipmentSlot> slots = EnumSet.allOf(EquipmentSlot.class);

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder oldItem(ItemPredicate item) {
            this.oldItem = Optional.ofNullable(item);
            return this;
        }

        public Builder newItem(ItemPredicate item) {
            this.newItem = Optional.ofNullable(item);
            return this;
        }

        public Builder slots(EquipmentSlot ... slots) {
            this.slots.clear();
            Collections.addAll(this.slots, slots);
            return this;
        }

        public Builder slots(EquipmentSlot.Type type) {
            this.slots.clear();
            Arrays.stream(EquipmentSlot.values()).filter(s -> s.getType() == type).forEach(this.slots::add);
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.EQUIP_ITEM.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.oldItem, this.newItem, this.slots));
        }
    }
}

