/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class ExperienceChangeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player) {
        this.trigger(player, i -> i.matches(player));
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints levels, MinMaxBounds.Doubles progress, MinMaxBounds.Ints totalExperience) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("levels", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::levels), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("progress", (Object)MinMaxBounds.Doubles.ANY).forGetter(TriggerInstance::progress), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("total_experience", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::totalExperience)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerPlayer player) {
            if (!this.levels.matches(player.experienceLevel)) {
                return false;
            }
            if (!this.progress.matches((double)player.experienceProgress)) {
                return false;
            }
            return this.totalExperience.matches(player.totalExperience);
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private MinMaxBounds.Ints levels = MinMaxBounds.Ints.ANY;
        private MinMaxBounds.Doubles progress = MinMaxBounds.Doubles.ANY;
        private MinMaxBounds.Ints totalExperience = MinMaxBounds.Ints.ANY;

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder levels(MinMaxBounds.Ints levels) {
            this.levels = levels;
            return this;
        }

        public Builder progress(MinMaxBounds.Doubles progress) {
            this.progress = progress;
            return this;
        }

        public Builder totalExperience(MinMaxBounds.Ints totalExperience) {
            this.totalExperience = totalExperience;
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.EXPERIENCE_CHANGED.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.levels, this.progress, this.totalExperience));
        }
    }
}

