/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;

public class FillBundleTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Inventory inventory) {
        this.trigger(player, instance -> instance.matches(inventory));
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.FILL_BUNDLE.get().trigger(player, inventory));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, int amount) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Codec.INT.optionalFieldOf("amount", (Object)64).forGetter(TriggerInstance::amount)).apply((Applicative)instance, TriggerInstance::new));
        private static final Fraction FULL_STACK = Fraction.getFraction((int)64, (int)1);

        public boolean matches(Inventory inventory) {
            for (ItemStack item : inventory) {
                BundleContents bundleContents;
                if (!item.is(ItemTags.BUNDLES) || (bundleContents = (BundleContents)item.get(DataComponents.BUNDLE_CONTENTS)) == null || bundleContents.weight().multiplyBy(FULL_STACK).intValue() < this.amount) continue;
                return true;
            }
            return false;
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private int amount = 64;

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.FILL_BUNDLE.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.amount));
        }
    }
}

