/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class GrowBeeNestTreeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, BlockPos nestPos, BlockState nestState, ItemStack tool) {
        LootParams nestParams = new LootParams.Builder(player.level()).withParameter(LootContextParams.ORIGIN, (Object)nestPos.getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.BLOCK_STATE, (Object)nestState).withParameter(LootContextParams.TOOL, (Object)tool).create(LootContextParamSets.ADVANCEMENT_LOCATION);
        LootContext nest = new LootContext.Builder(nestParams).create(Optional.empty());
        this.trigger(player, instance -> instance.matches(nest));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> nest) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ContextAwarePredicate.CODEC.optionalFieldOf("nest").forGetter(TriggerInstance::nest)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> grew() {
            return BingoTriggers.GROW_BEE_NEST_TREE.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty()));
        }

        public boolean matches(LootContext nest) {
            return this.nest.isEmpty() || this.nest.get().matches(nest);
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            this.nest.ifPresent(p -> criterionValidator.validate(p, LootContextParamSets.ADVANCEMENT_LOCATION, ".nest"));
        }
    }
}

