/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.ext.GlobalVars;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.jetbrains.annotations.NotNull;

public class GrowFeatureTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public static boolean wrapPlaceOperation(ConfiguredFeature<?, ?> feature, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, Operation<Boolean> operation) {
        Player player;
        boolean result = (Boolean)operation.call(new Object[]{feature, level, chunkGen, rand, pos});
        if (result && (player = GlobalVars.CURRENT_PLAYER.get()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Registry registry = level.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE);
            Holder.Reference holder = registry.getOrThrow((ResourceKey)registry.getResourceKey(feature).orElseThrow());
            BingoTriggers.GROW_FEATURE.get().trigger(player2, player2.level(), pos, (Holder<ConfiguredFeature<?, ?>>)holder);
        }
        return result;
    }

    public void trigger(ServerPlayer player, ServerLevel level, BlockPos pos, Holder<ConfiguredFeature<?, ?>> feature) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(level, pos, feature));
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<LocationPredicate> location, List<TagPredicate<ConfiguredFeature<?, ?>>> tags) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<List<TagPredicate<ConfiguredFeature<?, ?>>>> TAGS_CODEC = TagPredicate.codec((ResourceKey)Registries.CONFIGURED_FEATURE).listOf();
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location), (App)TAGS_CODEC.optionalFieldOf("tags", List.of()).forGetter(TriggerInstance::tags)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerLevel level, BlockPos pos, Holder<ConfiguredFeature<?, ?>> feature) {
            if (this.location.isPresent() && !this.location.get().matches(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5)) {
                return false;
            }
            for (TagPredicate<ConfiguredFeature<?, ?>> tag : this.tags) {
                if (tag.matches(feature)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private Optional<LocationPredicate> location = Optional.empty();
        private final List<TagPredicate<ConfiguredFeature<?, ?>>> tags = new ArrayList();

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder location(LocationPredicate location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        public Builder feature(TagPredicate<ConfiguredFeature<?, ?>> feature) {
            this.tags.add(feature);
            return this;
        }

        public Builder feature(TagKey<ConfiguredFeature<?, ?>> feature) {
            return this.feature(TagPredicate.is(feature));
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.GROW_FEATURE.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.location, List.copyOf(this.tags)));
        }
    }
}

