/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HasSomeFoodItemsTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Inventory inventory) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.trigger(player, instance -> instance.matches(player, inventory, progressListener));
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.HAS_SOME_FOOD_ITEMS.get().trigger(player, inventory));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, int requiredCount, Optional<TagPredicate<Item>> tag) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ExtraCodecs.POSITIVE_INT.fieldOf("required_count").forGetter(TriggerInstance::requiredCount), (App)TagPredicate.codec((ResourceKey)Registries.ITEM).optionalFieldOf("tag").forGetter(TriggerInstance::tag)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerPlayer player, Inventory inventory, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            ServerLevel level = player.level();
            RecipeManager recipeManager = level.getServer().getRecipeManager();
            Set foundItems = Sets.newIdentityHashSet();
            int l = inventory.getContainerSize();
            for (int i = 0; i < l; ++i) {
                FoodProperties food;
                ItemStack item = inventory.getItem(i);
                if (this.tag.isPresent() && !this.tag.get().matches(item.getItemHolder()) || (food = (FoodProperties)item.get(DataComponents.FOOD)) == null) continue;
                SingleRecipeInput input = new SingleRecipeInput(item);
                Optional recipe = recipeManager.getRecipeFor(RecipeType.SMELTING, (RecipeInput)input, (Level)level);
                if (recipe.isPresent()) {
                    item = ((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).assemble(input, (HolderLookup.Provider)level.registryAccess());
                }
                if (!foundItems.add(item.getItem()) || foundItems.size() < this.requiredCount) continue;
                progressListener.update(this, this.requiredCount, this.requiredCount);
                return true;
            }
            progressListener.update(this, foundItems.size(), this.requiredCount);
            return false;
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        @Nullable
        private Integer requiredCount = null;
        private Optional<TagPredicate<Item>> tag = Optional.empty();

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder requiredCount(int requiredCount) {
            this.requiredCount = requiredCount;
            return this;
        }

        public Builder tag(TagKey<Item> tag) {
            return this.tag((TagPredicate<Item>)TagPredicate.is(tag));
        }

        public Builder tag(TagPredicate<Item> tag) {
            this.tag = Optional.of(tag);
            return this;
        }

        public Criterion<TriggerInstance> build() {
            if (this.requiredCount == null) {
                throw new IllegalStateException("Did not specify requiredCount");
            }
            return BingoTriggers.HAS_SOME_FOOD_ITEMS.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.requiredCount, this.tag));
        }
    }
}

