/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import io.github.gaming32.bingo.util.BingoCodecs;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HasSomeItemsFromTagTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Inventory inventory) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.trigger(player, triggerInstance -> triggerInstance.matches(inventory, progressListener));
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.HAS_SOME_ITEMS_FROM_TAG.get().trigger(player, inventory));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, TagKey<Item> tag, int requiredCount) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final int ALL = -1;
        private static final Codec<Integer> REQUIRED_COUNT_CODEC = BingoCodecs.firstValid(ExtraCodecs.POSITIVE_INT, BingoCodecs.exactly(-1));
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(TriggerInstance::tag), (App)REQUIRED_COUNT_CODEC.fieldOf("required_count").forGetter(TriggerInstance::requiredCount)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(Inventory inventory, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            int requiredCount = this.requiredCount;
            if (requiredCount == -1) {
                Optional tag = BuiltInRegistries.ITEM.get(this.tag);
                if (tag.isEmpty()) {
                    return false;
                }
                requiredCount = ((HolderSet.Named)tag.get()).size();
            }
            Set foundItems = Sets.newIdentityHashSet();
            int l = inventory.getContainerSize();
            for (int i = 0; i < l; ++i) {
                ItemStack item = inventory.getItem(i);
                if (!item.is(this.tag) || !foundItems.add(item.getItem()) || foundItems.size() < requiredCount) continue;
                progressListener.update(this, requiredCount, requiredCount);
                return true;
            }
            progressListener.update(this, foundItems.size(), requiredCount);
            return false;
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private TagKey<Item> tag;
        @Nullable
        private Integer requiredCount = null;

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder tag(TagKey<Item> tag) {
            this.tag = tag;
            return this;
        }

        public Builder requiredCount(int requiredCount) {
            this.requiredCount = requiredCount;
            return this;
        }

        public Builder requiresAll() {
            return this.requiredCount(-1);
        }

        public Criterion<TriggerInstance> build() {
            if (this.tag == null) {
                throw new IllegalStateException("Did not specify tag");
            }
            if (this.requiredCount == null) {
                throw new IllegalStateException("Did not specify requiredCount");
            }
            return BingoTriggers.HAS_SOME_ITEMS_FROM_TAG.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.tag, this.requiredCount));
        }
    }
}

