/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.subpredicates.ItemEntityPredicate;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;

public class ItemPickedUpTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, ItemEntity itemEntity) {
        LootContext itemEntityContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)itemEntity);
        this.trigger(player, instance -> instance.matches(itemEntityContext));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> itemEntity) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("item_entity").forGetter(TriggerInstance::itemEntity)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> pickedUp(EntityPredicate itemEntity) {
            return BingoTriggers.ITEM_PICKED_UP.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), EntityPredicate.wrap(Optional.ofNullable(itemEntity))));
        }

        public static Criterion<TriggerInstance> pickedUpFrom(EntityPredicate droppedBy) {
            return TriggerInstance.pickedUpFrom(null, droppedBy);
        }

        public static Criterion<TriggerInstance> pickedUpFrom(ItemPredicate item, EntityPredicate droppedBy) {
            return TriggerInstance.pickedUp(EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)ItemEntityPredicate.droppedBy(Optional.ofNullable(item), Optional.ofNullable(droppedBy))).build());
        }

        public boolean matches(LootContext itemEntity) {
            return this.itemEntity.isEmpty() || this.itemEntity.get().matches(itemEntity);
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            criterionValidator.validateEntity(this.itemEntity, ".item_entity");
        }
    }
}

