/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import org.jetbrains.annotations.NotNull;

public class KillSelfTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, DamageSource killingBlow) {
        this.trigger(player, instance -> instance.matches(player, killingBlow));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<DamageSourcePredicate> killingBlow) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)DamageSourcePredicate.CODEC.optionalFieldOf("killing_blow").forGetter(TriggerInstance::killingBlow)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> killSelf() {
            return BingoTriggers.KILL_SELF.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty()));
        }

        public static Criterion<TriggerInstance> killSelf(DamageSourcePredicate killingBlow) {
            return BingoTriggers.KILL_SELF.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.ofNullable(killingBlow)));
        }

        public boolean matches(ServerPlayer player, DamageSource killingBlow) {
            return this.killingBlow.isEmpty() || this.killingBlow.get().matches(player, killingBlow);
        }
    }
}

