/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.data.tags.bingo.BingoBlockTags;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MineralPillarTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, BlockGetter level, BlockPos pos) {
        this.trigger(player, instance -> instance.matches(level, pos));
    }

    public static Criterion<TriggerInstance> pillar(TagKey<Block> tag) {
        return BingoTriggers.MINERAL_PILLAR.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), tag));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, TagKey<Block> tag) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("tag").forGetter(TriggerInstance::tag)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(BlockGetter level, BlockPos pos) {
            int required = BuiltInRegistries.BLOCK.get(this.tag).map(HolderSet::size).orElse(0);
            BlockState state = this.getState(level, pos);
            if (state.is(this.tag)) {
                if (required <= 1) {
                    return true;
                }
            } else {
                return required == 0;
            }
            HashSet<BlockState> found = HashSet.newHashSet(required);
            found.add(state);
            BlockPos.MutableBlockPos currentPos = pos.mutable();
            if (this.loop(level, currentPos, 1, required, found)) {
                return true;
            }
            currentPos.set((Vec3i)pos);
            return this.loop(level, currentPos, -1, required, found);
        }

        private boolean loop(BlockGetter level, BlockPos.MutableBlockPos currentPos, int direction, int required, Set<BlockState> found) {
            block1: {
                do {
                    currentPos.setY(currentPos.getY() + direction);
                    BlockState state = this.getState(level, (BlockPos)currentPos);
                    if (!state.is(this.tag) || !found.add(state)) break block1;
                } while (found.size() < required);
                return true;
            }
            return false;
        }

        private BlockState getState(BlockGetter level, BlockPos pos) {
            BlockState result = level.getBlockState(pos);
            if (result.is(BingoBlockTags.COPPER_BLOCKS)) {
                return Blocks.COPPER_BLOCK.defaultBlockState();
            }
            return result;
        }
    }
}

