/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class PartyParrotsTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, JukeboxBlockEntity blockEntity) {
        this.trigger(player, instance -> instance.matches(blockEntity));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> partyParrots() {
            return BingoTriggers.PARTY_PARROTS.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty()));
        }

        public boolean matches(JukeboxBlockEntity blockEntity) {
            if (!blockEntity.getSongPlayer().isPlaying() || blockEntity.getLevel() == null) {
                return false;
            }
            EnumSet<Parrot.Variant> parrotsNeeded = EnumSet.allOf(Parrot.Variant.class);
            for (Parrot parrot : blockEntity.getLevel().getEntitiesOfClass(Parrot.class, new AABB(blockEntity.getBlockPos()).inflate(3.0))) {
                parrotsNeeded.remove(parrot.getVariant());
                if (!parrotsNeeded.isEmpty()) continue;
                return true;
            }
            return false;
        }
    }
}

