/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.ext.LeashFenceKnotEntityExt;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PulledByLeashTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Entity entity, @Nullable LeashFenceKnotEntity knot, Vec3 force) {
        LootContext mobContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)entity);
        Optional<LootContext> knotContext = Optional.ofNullable(knot).map(e -> EntityPredicate.createContext((ServerPlayer)player, (Entity)e));
        this.trigger(player, instance -> instance.matches(mobContext, knotContext, force));
    }

    public void tryTrigger(Entity entity, Vec3 force, Operation<Void> original, @Nullable Entity leashHolder) {
        LeashFenceKnotEntity knot;
        original.call(new Object[]{entity, force});
        Player player = PulledByLeashTrigger.getLeashPlayer(leashHolder);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        this.trigger(serverPlayer, entity, leashHolder instanceof LeashFenceKnotEntity ? (knot = (LeashFenceKnotEntity)leashHolder) : null, force);
    }

    @Nullable
    private static Player getLeashPlayer(@Nullable Entity leashHolder) {
        if (leashHolder instanceof Player) {
            Player player = (Player)leashHolder;
            return player;
        }
        if (leashHolder instanceof LeashFenceKnotEntityExt) {
            LeashFenceKnotEntityExt knot = (LeashFenceKnotEntityExt)leashHolder;
            return knot.bingo$getOwner();
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> mob, Optional<ContextAwarePredicate> knot, Optional<Boolean> knotRequired, Optional<DistancePredicate> force) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("mob").forGetter(TriggerInstance::mob), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("knot").forGetter(TriggerInstance::knot), (App)Codec.BOOL.optionalFieldOf("knot_required").forGetter(TriggerInstance::knotRequired), (App)DistancePredicate.CODEC.optionalFieldOf("force").forGetter(TriggerInstance::force)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(LootContext mob, Optional<LootContext> leash, Vec3 force) {
            if (this.mob.isPresent() && !this.mob.get().matches(mob)) {
                return false;
            }
            if (leash.isPresent()) {
                if (this.knotRequired.isPresent() && !this.knotRequired.get().booleanValue()) {
                    return false;
                }
                if (this.knot.isPresent() && !this.knot.get().matches(leash.get())) {
                    return false;
                }
            } else if (this.knotRequired.isPresent() && this.knotRequired.get().booleanValue()) {
                return false;
            }
            return !this.force.isPresent() || this.force.get().matches(0.0, 0.0, 0.0, force.x, force.y, force.z);
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            criterionValidator.validateEntity(this.mob, ".mob");
            criterionValidator.validateEntity(this.knot, ".knot");
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private Optional<ContextAwarePredicate> mob = Optional.empty();
        private Optional<ContextAwarePredicate> knot = Optional.empty();
        private Optional<Boolean> knotRequired = Optional.empty();
        private Optional<DistancePredicate> force = Optional.empty();

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder player(EntityPredicate.Builder player) {
            return this.player(EntityPredicate.wrap((EntityPredicate.Builder)player));
        }

        public Builder mob(ContextAwarePredicate mob) {
            this.mob = Optional.of(mob);
            return this;
        }

        public Builder mob(EntityPredicate.Builder mob) {
            return this.mob(EntityPredicate.wrap((EntityPredicate.Builder)mob));
        }

        public Builder knot(ContextAwarePredicate knot) {
            this.knot = Optional.of(knot);
            return this;
        }

        public Builder knot(EntityPredicate.Builder knot) {
            return this.knot(EntityPredicate.wrap((EntityPredicate.Builder)knot));
        }

        public Builder knotRequired(boolean knotRequired) {
            this.knotRequired = Optional.of(knotRequired);
            return this;
        }

        public Builder force(DistancePredicate force) {
            this.force = Optional.of(force);
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.PULLED_BY_LEASH.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.mob, this.knot, this.knotRequired, this.force));
        }
    }
}

