/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class RelativeStatsTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.trigger(player, instance -> instance.matches(player, progressListener));
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, List<PlayerPredicate.StatMatcher<?>> stats) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)PlayerPredicate.StatMatcher.CODEC.listOf().fieldOf("stats").forGetter(TriggerInstance::stats)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerPlayer player, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            MinecraftServer server = player.level().getServer();
            BingoGame game = ((MinecraftServerExt)server).bingo$getGame();
            if (game != null) {
                Object2IntMap<Stat<?>> baseStats = game.getBaseStats((Player)player);
                ServerStatsCounter currentStats = player.getStats();
                for (PlayerPredicate.StatMatcher<?> matcher : this.stats) {
                    Stat stat = (Stat)matcher.stat().get();
                    int currentValue = currentStats.getValue(stat);
                    int value = currentValue - baseStats.getOrDefault((Object)stat, currentValue);
                    if (matcher.range().matches(value)) continue;
                    matcher.range().min().ifPresent(min -> progressListener.update(this, Math.min(value, min), (int)min));
                    return false;
                }
                if (!this.stats.isEmpty()) {
                    this.stats.getFirst().range().min().ifPresent(min -> progressListener.update(this, (int)min, (int)min));
                }
            }
            return true;
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private final List<PlayerPredicate.StatMatcher<?>> stats = new ArrayList();

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public <T> Builder stat(StatType<T> statType, Holder.Reference<T> stat, MinMaxBounds.Ints range) {
            this.stats.add(new PlayerPredicate.StatMatcher(statType, stat, range));
            return this;
        }

        public Builder stat(ResourceLocation customStat, MinMaxBounds.Ints range) {
            return this.stat(Stats.CUSTOM, BuiltInRegistries.CUSTOM_STAT.getOrThrow(ResourceKey.create((ResourceKey)Registries.CUSTOM_STAT, (ResourceLocation)customStat)), range);
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.RELATIVE_STATS.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.stats));
        }
    }
}

