/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class ShootBellTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, BlockPos pos, Projectile projectile) {
        ServerLevel level = player.level();
        BlockState state = level.getBlockState(pos);
        LootParams locationParams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)pos.getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.TOOL, (Object)player.getMainHandItem()).create(LootContextParamSets.ADVANCEMENT_LOCATION);
        LootContext projectileContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)projectile);
        LootContext bell = new LootContext.Builder(locationParams).create(Optional.empty());
        this.trigger(player, triggerInstance -> triggerInstance.matches(player, pos, bell, projectileContext));
    }

    public static Builder builder() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> bell, Optional<ContextAwarePredicate> projectile, Optional<DistancePredicate> distance) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ContextAwarePredicate.CODEC.optionalFieldOf("bell").forGetter(TriggerInstance::bell), (App)ContextAwarePredicate.CODEC.optionalFieldOf("projectile").forGetter(TriggerInstance::projectile), (App)DistancePredicate.CODEC.optionalFieldOf("distance").forGetter(TriggerInstance::distance)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerPlayer player, BlockPos bellLocation, LootContext bell, LootContext projectile) {
            if (this.bell.isPresent() && !this.bell.get().matches(bell)) {
                return false;
            }
            if (this.projectile.isPresent() && !this.projectile.get().matches(projectile)) {
                return false;
            }
            return !this.distance.isPresent() || this.distance.get().matches(player.getX(), player.getY(), player.getZ(), (double)bellLocation.getX() + 0.5, (double)bellLocation.getY() + 0.5, (double)bellLocation.getZ() + 0.5);
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            this.bell.ifPresent(p -> criterionValidator.validate(p, LootContextParamSets.ADVANCEMENT_LOCATION, ".location"));
            this.projectile.ifPresent(p -> criterionValidator.validate(p, LootContextParamSets.ADVANCEMENT_ENTITY, ".projectile"));
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private Optional<ContextAwarePredicate> bell = Optional.empty();
        private Optional<ContextAwarePredicate> projectile = Optional.empty();
        private Optional<DistancePredicate> distance = Optional.empty();

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder bell(ContextAwarePredicate bell) {
            this.bell = Optional.of(bell);
            return this;
        }

        public Builder bell(LootItemCondition ... conditions) {
            return this.bell(ContextAwarePredicate.create((LootItemCondition[])conditions));
        }

        public Builder bell(LocationPredicate bell) {
            return this.bell(new LootItemCondition[]{new LocationCheck(Optional.ofNullable(bell), BlockPos.ZERO)});
        }

        public Builder projectile(ContextAwarePredicate projectile) {
            this.projectile = Optional.of(projectile);
            return this;
        }

        public Builder projectile(EntityPredicate projectile) {
            return this.projectile(EntityPredicate.wrap((EntityPredicate)projectile));
        }

        public Builder distance(DistancePredicate distance) {
            this.distance = Optional.of(distance);
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.SHOOT_BELL.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.bell, this.projectile, this.distance));
        }
    }
}

