/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TotalCountInventoryChangeTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Inventory inventory) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.trigger(player, triggerInstance -> triggerInstance.matches(inventory, progressListener));
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.TOTAL_COUNT_INVENTORY_CHANGED.get().trigger(player, inventory));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, List<ItemPredicate> items) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ItemPredicate.CODEC.listOf().fieldOf("items").forGetter(TriggerInstance::items)).apply((Applicative)instance, TriggerInstance::new));

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean matches(Inventory inventory, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            int[] counts = new int[this.items.size()];
            int l = inventory.getContainerSize();
            for (int i = 0; i < l; ++i) {
                ItemStack item = inventory.getItem(i);
                if (item.isEmpty()) continue;
                for (int predicateIndex = 0; predicateIndex < counts.length; ++predicateIndex) {
                    ItemPredicate predicate = this.items.get(predicateIndex);
                    int itemCount = item.getCount();
                    try {
                        item.setCount(predicate.count().min().orElse(1).intValue());
                        if (!predicate.test(item)) continue;
                        int n = predicateIndex;
                        counts[n] = counts[n] + itemCount;
                        continue;
                    }
                    finally {
                        item.setCount(itemCount);
                    }
                }
            }
            int validCount = 0;
            Integer minCount = this.getMinCount();
            for (int predicateIndex = 0; predicateIndex < counts.length; ++predicateIndex) {
                if (counts[predicateIndex] == 0) {
                    if (minCount != null) continue;
                    return false;
                }
                MinMaxBounds.Ints countPredicate = this.items.get(predicateIndex).count();
                boolean matched = countPredicate.matches(counts[predicateIndex]);
                if (minCount == null) {
                    if (matched) continue;
                    return false;
                }
                validCount += matched ? countPredicate.min().orElse(1) : counts[predicateIndex];
            }
            if (minCount != null) {
                progressListener.update(this, validCount, minCount);
                return validCount >= minCount;
            }
            return true;
        }

        private Integer getMinCount() {
            boolean allMin = this.items.stream().allMatch(p -> p.count().max().isEmpty());
            if (!allMin) {
                return null;
            }
            return this.items.stream().mapToInt(p -> p.count().min().orElse(1)).sum();
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private final List<ItemPredicate> items = new ArrayList<ItemPredicate>();

        private Builder() {
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder items(ItemPredicate ... items) {
            Collections.addAll(this.items, items);
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.TOTAL_COUNT_INVENTORY_CHANGED.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, List.copyOf(this.items)));
        }
    }
}

