/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.NotNull;

public class WearDifferentColoredArmorTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Inventory inventory) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.trigger(player, instance -> instance.matches(inventory, progressListener));
    }

    public static Builder builder(int minCount) {
        return new Builder(minCount);
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.WEAR_DIFFERENT_COLORED_ARMOR.get().trigger(player, inventory));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, boolean allowUncolored, int minCount, Optional<ItemPredicate> itemPredicate) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Codec.BOOL.optionalFieldOf("allow_uncolored", (Object)true).forGetter(TriggerInstance::allowUncolored), (App)ExtraCodecs.POSITIVE_INT.fieldOf("min_count").forGetter(TriggerInstance::minCount), (App)ItemPredicate.CODEC.optionalFieldOf("item_predicate").forGetter(TriggerInstance::itemPredicate)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(Inventory inventory, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            IntOpenHashSet discovered = new IntOpenHashSet();
            for (EquipmentSlot slot : EquipmentSlotGroup.ARMOR) {
                ItemStack item = inventory.player.getItemBySlot(slot);
                if (this.itemPredicate.isPresent() && !this.itemPredicate.get().test(item) || !item.is(ItemTags.DYEABLE)) continue;
                DyedItemColor color = (DyedItemColor)item.get(DataComponents.DYED_COLOR);
                if (!this.allowUncolored && color == null || !discovered.add(color != null ? color.rgb() : -1) || discovered.size() < this.minCount) continue;
                progressListener.update(this, this.minCount, this.minCount);
                return true;
            }
            progressListener.update(this, discovered.size(), this.minCount);
            return false;
        }
    }

    public static final class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private boolean allowUncolored = true;
        private final int minCount;
        private Optional<ItemPredicate> itemPredicate = Optional.empty();

        private Builder(int minCount) {
            this.minCount = minCount;
        }

        public Builder player(ContextAwarePredicate player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder allowUncolored() {
            this.allowUncolored = true;
            return this;
        }

        public Builder itemPredicate(ItemPredicate itemPredicate) {
            this.itemPredicate = Optional.of(itemPredicate);
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.WEAR_DIFFERENT_COLORED_ARMOR.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.allowUncolored, this.minCount, this.itemPredicate));
        }
    }
}

