/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;

public class ZombifyPigTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Pig pig, Entity zombifiedPiglin, boolean direct) {
        LootContext pigContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)pig);
        LootContext zombifiedPiglinContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)zombifiedPiglin);
        this.trigger(player, instance -> instance.matches(pigContext, zombifiedPiglinContext, direct));
    }

    public static Builder zombifyPig() {
        return new Builder();
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> pig, Optional<ContextAwarePredicate> zombifiedPiglin, Optional<Boolean> direct) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("pig").forGetter(TriggerInstance::pig), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("zombified_piglin").forGetter(TriggerInstance::zombifiedPiglin), (App)Codec.BOOL.optionalFieldOf("direct").forGetter(TriggerInstance::direct)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(LootContext pig, LootContext zombifiedPiglin, boolean direct) {
            if (this.pig.isPresent() && !this.pig.get().matches(pig)) {
                return false;
            }
            if (this.zombifiedPiglin.isPresent() && !this.zombifiedPiglin.get().matches(zombifiedPiglin)) {
                return false;
            }
            return !this.direct.isPresent() || direct == this.direct.get();
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
            criterionValidator.validateEntity(this.pig, ".pig");
            criterionValidator.validateEntity(this.zombifiedPiglin, ".zombified_piglin");
        }
    }

    public static class Builder {
        private Optional<ContextAwarePredicate> player = Optional.empty();
        private Optional<ContextAwarePredicate> pig = Optional.empty();
        private Optional<ContextAwarePredicate> zombifiedPiglin = Optional.empty();
        private Optional<Boolean> direct = Optional.empty();

        private Builder() {
        }

        public Builder player(ContextAwarePredicate predicate) {
            this.player = Optional.ofNullable(predicate);
            return this;
        }

        public Builder player(EntityPredicate predicate) {
            return this.player(EntityPredicate.wrap((EntityPredicate)predicate));
        }

        public Builder pig(ContextAwarePredicate predicate) {
            this.pig = Optional.ofNullable(predicate);
            return this;
        }

        public Builder pig(EntityPredicate predicate) {
            return this.pig(EntityPredicate.wrap((EntityPredicate)predicate));
        }

        public Builder zombifiedPiglin(ContextAwarePredicate predicate) {
            this.zombifiedPiglin = Optional.ofNullable(predicate);
            return this;
        }

        public Builder zombifiedPiglin(EntityPredicate predicate) {
            return this.zombifiedPiglin(EntityPredicate.wrap((EntityPredicate)predicate));
        }

        public Builder direct(boolean direct) {
            this.direct = Optional.of(direct);
            return this;
        }

        public Criterion<TriggerInstance> build() {
            return BingoTriggers.ZOMBIFY_PIG.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(this.player, this.pig, this.zombifiedPiglin, this.direct));
        }
    }
}

