/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers.progress;

import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;

public abstract class SimpleProgressibleCriterionTrigger<T extends SimpleCriterionTrigger.SimpleInstance>
extends SimpleCriterionTrigger<T>
implements ProgressibleTrigger<T> {
    private final Map<PlayerAdvancements, List<ProgressibleTrigger.ProgressListener<T>>> progressListeners = new IdentityHashMap<PlayerAdvancements, List<ProgressibleTrigger.ProgressListener<T>>>();

    @Override
    public void addProgressListener(PlayerAdvancements player, ProgressibleTrigger.ProgressListener<T> listener) {
        this.progressListeners.computeIfAbsent(player, k -> new ArrayList()).add(listener);
    }

    @Override
    public void removeProgressListener(PlayerAdvancements player, ProgressibleTrigger.ProgressListener<T> listener) {
        List<ProgressibleTrigger.ProgressListener<T>> listeners = this.progressListeners.get(player);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            this.progressListeners.remove(player);
        }
    }

    @Override
    public void removeProgressListeners(PlayerAdvancements player) {
        this.progressListeners.remove(player);
    }

    protected ProgressibleTrigger.ProgressListener<T> getProgressListener(ServerPlayer player) {
        List listeners = this.progressListeners.get(player.getAdvancements());
        if (listeners == null) {
            return (triggerInstance, progress, maxProgress) -> {};
        }
        if (listeners.size() == 1) {
            return listeners.getFirst();
        }
        return (triggerInstance, progress, maxProgress) -> {
            for (ProgressibleTrigger.ProgressListener listener : listeners) {
                listener.update(triggerInstance, progress, maxProgress);
            }
        };
    }
}

