/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.util;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.util.BingoCodecs;
import it.unimi.dsi.fastutil.Hash;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.NotNull;

public class BingoUtil {
    private static final Hash.Strategy<Holder<?>> HOLDER_STRATEGY = new Hash.Strategy<Holder<?>>(){

        public int hashCode(Holder<?> holder) {
            if (holder == null) {
                return 0;
            }
            Optional key = holder.unwrapKey();
            return key.isPresent() ? System.identityHashCode(key.get()) : holder.hashCode();
        }

        public boolean equals(Holder<?> a, Holder<?> b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.getClass() != b.getClass()) {
                return false;
            }
            Optional keyA = a.unwrapKey();
            if (keyA.isPresent() && keyA.equals(b.unwrapKey())) {
                return true;
            }
            return a.equals(b);
        }
    };

    public static <T> Hash.Strategy<Holder<T>> holderStrategy() {
        return HOLDER_STRATEGY;
    }

    public static int[] generateIntArray(int length) {
        int[] result = new int[length];
        for (int i = 1; i < length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public static int[] shuffle(int[] a, RandomSource random) {
        int i = a.length;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            int t = a[i];
            a[i] = a[p];
            a[p] = t;
        }
        return a;
    }

    public static Collector<JsonElement, ?, JsonArray> toJsonArray() {
        return Collector.of(JsonArray::new, JsonArray::add, (a, b) -> {
            a.addAll(b);
            return a;
        }, new Collector.Characteristics[0]);
    }

    public static CompoundTag compound(Map<String, ? extends Tag> nbt) {
        CompoundTag result = new CompoundTag();
        nbt.forEach((arg_0, arg_1) -> ((CompoundTag)result).put(arg_0, arg_1));
        return result;
    }

    public static ListTag list(List<? extends Tag> nbt) {
        ListTag result = new ListTag();
        result.addAll(nbt);
        return result;
    }

    public static <T> JsonElement toJsonElement(Codec<T> codec, T obj) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, obj).getOrThrow();
    }

    public static <T> Dynamic<?> toDynamic(Codec<T> codec, T obj) {
        return BingoUtil.toDynamic(codec, obj, BingoCodecs.DEFAULT_OPS);
    }

    public static <T, O> Dynamic<O> toDynamic(Codec<T> codec, T obj, DynamicOps<O> ops) {
        return new Dynamic(ops, codec.encodeStart(ops, obj).getOrThrow());
    }

    public static <T> T fromDynamic(Codec<T> codec, Dynamic<?> dynamic) throws IllegalArgumentException {
        return (T)codec.parse(dynamic).getOrThrow(IllegalArgumentException::new);
    }

    public static <T extends Enum<T>> T valueOf(String name, @NotNull T defaultValue) {
        try {
            return Enum.valueOf(defaultValue.getDeclaringClass(), name);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static MutableComponent ordinal(int n) {
        if (n >= 1 && n <= 16) {
            return Bingo.translatable("bingo.ordinal." + n, new Object[0]);
        }
        return Bingo.translatable("bingo.ordinal.generic", n);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static MutableComponent ensureHasFallback(MutableComponent component) {
        block10: {
            block11: {
                var2_1 = component.getContents();
                if (!(var2_1 instanceof TranslatableContents) || (translatable = (TranslatableContents)var2_1).getFallback() != null) break block10;
                fallbackText = Language.getInstance().getOrDefault(translatable.getKey(), null);
                args = translatable.getArgs();
                if (args.length > 0) {
                    args = (Object[])args.clone();
                    for (i = 0; i < args.length; ++i) {
                        var6_8 = args[i];
                        if (!(var6_8 instanceof MutableComponent)) continue;
                        subComponent = (MutableComponent)var6_8;
                        args[i] = BingoUtil.ensureHasFallback((MutableComponent)subComponent);
                    }
                }
                if ((style = component.getStyle()).getHoverEvent() == null) break block11;
                var8_11 /* !! */  = style.getHoverEvent();
                if (!(var8_11 /* !! */  instanceof HoverEvent.ShowText)) ** GOTO lbl-1000
                subComponent = (HoverEvent.ShowText)var8_11 /* !! */ ;
                try {
                    var9_12 = subComponent.value();
                }
                catch (Throwable var1_3) {
                    throw new MatchException(var1_3.toString(), var1_3);
                }
                if (var9_12 instanceof MutableComponent) {
                    hoverText = (MutableComponent)var9_12;
                    style = style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)BingoUtil.ensureHasFallback(hoverText)));
                } else if ((var8_11 /* !! */  = style.getHoverEvent()) instanceof HoverEvent.EntityTooltipInfo) {
                    info = (HoverEvent.EntityTooltipInfo)var8_11 /* !! */ ;
                    var9_12 = info.name.orElse(null);
                    if (var9_12 instanceof MutableComponent) {
                        mutableComponent = (MutableComponent)var9_12;
                        style = style.withHoverEvent((HoverEvent)new HoverEvent.ShowEntity(new HoverEvent.EntityTooltipInfo(info.type, info.uuid, (Component)BingoUtil.ensureHasFallback(mutableComponent))));
                    }
                }
            }
            if (!(siblings = component.getSiblings()).isEmpty()) {
                siblings = new ArrayList<MutableComponent>(siblings);
                for (i = 0; i < siblings.size(); ++i) {
                    var8_11 /* !! */  = siblings.get(i);
                    if (!(var8_11 /* !! */  instanceof MutableComponent)) continue;
                    subComponent = (MutableComponent)var8_11 /* !! */ ;
                    siblings.set(i, BingoUtil.ensureHasFallback(subComponent));
                }
            }
            result = Component.translatableWithFallback((String)translatable.getKey(), (String)fallbackText, (Object[])args).setStyle(style);
            result.getSiblings().addAll(siblings);
            return result;
        }
        return component;
    }

    public static Either<Component, Component> getDisplayName(PlayerTeam team, PlayerList playerList) {
        Iterator players = team.getPlayers().stream().map(arg_0 -> ((PlayerList)playerList).getPlayerByName(arg_0)).filter(Objects::nonNull).iterator();
        if (players.hasNext()) {
            ServerPlayer player = (ServerPlayer)players.next();
            if (!players.hasNext()) {
                return Either.left((Object)player.getName());
            }
        }
        return Either.right((Object)team.getDisplayName());
    }

    public static <T, R> Either<R, R> mapEither(Either<? extends T, ? extends T> either, Function<? super T, ? extends R> mapper) {
        return either.mapBoth(mapper, mapper);
    }

    public static boolean collidesWithProjectedBox(Vec3 entityOrigin, Vec3 boxNormal, double boxWidth) {
        double pointDistance = entityOrigin.dot(boxNormal) / boxNormal.lengthSqr();
        if (pointDistance < 0.0) {
            return false;
        }
        Vec3 closestPoint = boxNormal.scale(pointDistance);
        double angle = BingoUtil.vectorAngle(closestPoint, entityOrigin);
        double maxDistance = BingoUtil.distanceToSquareEdge(angle, boxWidth / 2.0);
        return closestPoint.distanceToSqr(entityOrigin) <= maxDistance * maxDistance;
    }

    public static double vectorAngle(Vec3 a, Vec3 b) {
        return Math.acos(a.dot(b) / (a.length() * b.length()));
    }

    public static double distanceToSquareEdge(double angle, double squareRadius) {
        double cos;
        double sin = Math.abs(Math.sin(angle));
        return squareRadius * sin <= squareRadius * (cos = Math.abs(Math.cos(angle))) ? squareRadius / cos : squareRadius / sin;
    }

    public static <T> HolderSet<T> toHolderSet(Registry<T> registry, ResourceOrTagKeyArgument.Result<T> result) {
        return (HolderSet)result.unwrap().map(resource -> HolderSet.direct((Holder[])new Holder[]{registry.getOrThrow(resource)}), arg_0 -> registry.getOrThrow(arg_0));
    }

    public static <T> Set<T> copyAndAdd(Set<T> set, T value) {
        return ImmutableSet.builderWithExpectedSize((int)(set.size() + 1)).addAll(set).add(value).build();
    }

    public static <K, V> Multimap<K, V> copyAndPut(Multimap<K, V> map, K k, V v) {
        return ImmutableMultimap.builder().putAll(map).put(k, v).build();
    }

    public static <A> DataResult<A> combineError(DataResult<A> current, DataResult<?> other) {
        return current.apply2((a, b) -> a, other);
    }

    public static <A> DataResult<A> combineError(DataResult<A> current, Supplier<String> error) {
        return BingoUtil.combineError(current, DataResult.error(error));
    }
}

