/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.util;

import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.jetbrains.annotations.NotNull;

public class BlockPattern {
    private final Predicate<BlockInWorld>[][][] predicates;
    private final int xSize;
    private final int ySize;
    private final int zSize;

    public BlockPattern(Predicate<BlockInWorld>[][][] predicates) {
        this.predicates = predicates;
        this.zSize = predicates.length;
        this.ySize = Arrays.stream(predicates).mapToInt(aisle -> ((Predicate[][])aisle).length).max().orElse(0);
        this.xSize = Arrays.stream(predicates).flatMapToInt(aisle -> Arrays.stream(aisle).mapToInt(row -> ((Predicate[])row).length)).max().orElse(0);
    }

    private static void transformPos(BlockPos origin, BlockPos pos, Direction right, Direction up, Direction forward, BlockPos.MutableBlockPos outPos) {
        outPos.set(pos.getX() - origin.getX(), pos.getY() - origin.getY(), pos.getZ() - origin.getZ());
        outPos.set(outPos.getX() * right.getStepX() + outPos.getY() * up.getStepX() + outPos.getZ() * forward.getStepX() + origin.getX(), outPos.getX() * right.getStepY() + outPos.getY() * up.getStepY() + outPos.getZ() * forward.getStepY() + origin.getY(), outPos.getX() * right.getStepZ() + outPos.getY() * up.getStepZ() + outPos.getZ() * forward.getStepZ() + origin.getZ());
    }

    private boolean check(LevelReader level, BlockPos origin, BlockPos checkAt, Direction right, Direction up, Direction forward) {
        BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)checkAt, (BlockPos)checkAt.offset(this.xSize - 1, this.ySize - 1, this.zSize - 1))) {
            BlockPattern.transformPos(origin, pos, right, up, forward, tempPos);
            if (this.predicates[pos.getZ() - checkAt.getZ()][pos.getY() - checkAt.getY()][pos.getX() - checkAt.getX()].test(new BlockInWorld(level, (BlockPos)tempPos, false))) continue;
            return false;
        }
        return true;
    }

    private boolean find(LevelReader level, BlockPos origin, Direction right, Direction up, Direction forward) {
        for (BlockPos checkAt : BlockPos.betweenClosed((BlockPos)origin.subtract(new Vec3i(this.xSize - 1, this.ySize - 1, this.zSize - 1)), (BlockPos)origin)) {
            if (!this.check(level, origin, checkAt, right, up, forward)) continue;
            return true;
        }
        return false;
    }

    public boolean find(LevelReader level, BlockPos origin, Rotations rotations) {
        if (this.xSize == 0 || this.ySize == 0 || this.zSize == 0) {
            return true;
        }
        return switch (rotations.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.find(level, origin, Direction.EAST, Direction.UP, Direction.NORTH);
            case 1 -> {
                for (Direction right : Direction.Plane.HORIZONTAL) {
                    for (Direction forward : Direction.Plane.HORIZONTAL) {
                        if (right.getAxis() == forward.getAxis() || !this.find(level, origin, right, Direction.UP, forward)) continue;
                        yield true;
                    }
                }
                yield false;
            }
            case 2 -> {
                for (Direction right : Direction.values()) {
                    for (Direction forward : Direction.values()) {
                        if (forward.getAxis() == right.getAxis()) continue;
                        for (Direction up : Direction.values()) {
                            if (up.getAxis() == right.getAxis() || up.getAxis() == forward.getAxis() || !this.find(level, origin, right, up, forward)) continue;
                            yield true;
                        }
                    }
                }
                yield false;
            }
        };
    }

    public static enum Rotations implements StringRepresentable
    {
        NONE("none"),
        HORIZONTAL("horizontal"),
        ALL("all");

        public static final StringRepresentable.EnumCodec<Rotations> CODEC;
        private final String serializedName;

        private Rotations(String serializedName) {
            this.serializedName = serializedName;
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Rotations::values);
        }
    }
}

