/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.util;

import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;

public class CustomEnumCodec<E extends Enum<E>> {
    private final ImmutableBiMap<E, String> names;
    private final Codec<E> codec;

    private CustomEnumCodec(Class<E> clazz, Function<E, String> nameMapper) {
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException(String.valueOf(clazz) + " is not an enum!");
        }
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        ImmutableBiMap.Builder namesBuilder = ImmutableBiMap.builderWithExpectedSize((int)constants.length);
        for (Enum constant : constants) {
            namesBuilder.put((Object)constant, (Object)nameMapper.apply(constant));
        }
        this.names = namesBuilder.build();
        this.codec = Codec.STRING.comapFlatMap(name -> Optional.ofNullable((Enum)this.names.inverse().get(name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown value: " + name)), arg_0 -> this.names.get(arg_0));
    }

    public static <E extends Enum<E>> CustomEnumCodec<E> of(Class<E> clazz, Function<E, String> nameMapper) {
        return new CustomEnumCodec<E>(clazz, nameMapper);
    }

    public static <E extends Enum<E>> CustomEnumCodec<E> of(Class<E> clazz) {
        return new CustomEnumCodec<Enum>(clazz, e -> e.name().toLowerCase(Locale.ROOT));
    }

    public ImmutableBiMap<E, String> names() {
        return this.names;
    }

    public Codec<E> codec() {
        return this.codec;
    }
}

