/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class StatCodecs {
    public static final Codec<Stat<?>> CODEC = StatCodecs.createCodec();
    public static final Codec<Stat<?>> STRING_CODEC = StatCodecs.createStringCodec();

    private static <S> Codec<Stat<S>> createCodec() {
        return new MapCodec<Stat<S>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of(ops.createString("type"), ops.createString("stat"));
            }

            public <T> DataResult<Stat<S>> decode(DynamicOps<T> ops, MapLike<T> input) {
                DataResult<ResourceLocation> typeKey = 1.get(ops, input, "type");
                if (typeKey.result().isEmpty()) {
                    return DataResult.error(() -> ((DataResult.Error)((DataResult.Error)typeKey.error().orElseThrow())).message());
                }
                StatType type = (StatType)BuiltInRegistries.STAT_TYPE.getValue((ResourceLocation)typeKey.result().get());
                if (type == null) {
                    return DataResult.error(() -> "Unknown stat_type " + String.valueOf(typeKey.result().orElseThrow()));
                }
                DataResult<ResourceLocation> statKey = 1.get(ops, input, "stat");
                if (statKey.result().isEmpty()) {
                    return DataResult.error(() -> ((DataResult.Error)((DataResult.Error)statKey.error().orElseThrow())).message());
                }
                Object statId = type.getRegistry().getValue((ResourceLocation)statKey.result().get());
                if (statId == null) {
                    return DataResult.error(() -> "Unknown " + String.valueOf(typeKey.result().orElseThrow()) + " " + String.valueOf(statKey.result().orElseThrow()));
                }
                return DataResult.success((Object)type.get(statId));
            }

            public <T> RecordBuilder<T> encode(Stat<S> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                1.add(ops, prefix, "type", BuiltInRegistries.STAT_TYPE, input.getType());
                1.add(ops, prefix, "stat", input.getType().getRegistry(), input.getValue());
                return prefix;
            }

            private static <T> DataResult<ResourceLocation> get(DynamicOps<T> ops, MapLike<T> input, String key) {
                return Optional.ofNullable(input.get(key)).map(arg_0 -> ops.getStringValue(arg_0)).map(v -> v.flatMap(ResourceLocation::read)).orElseGet(() -> DataResult.error(() -> "key missing: " + key + " in " + String.valueOf(input)));
            }

            private static <T, V> void add(DynamicOps<T> ops, RecordBuilder<T> prefix, String name, Registry<V> registry, V value) {
                ResourceLocation key = registry.getKey(value);
                if (key == null) {
                    prefix.withErrorsFrom(DataResult.error(() -> "Unregistered value " + String.valueOf(value) + " in " + String.valueOf(registry.key().location())));
                    return;
                }
                prefix.add(name, ops.createString(key.toString()));
            }
        }.codec();
    }

    private static Codec<Stat<?>> createStringCodec() {
        return Codec.STRING.comapFlatMap(name -> ObjectiveCriteria.byName((String)name).map(criteria -> {
            if (!(criteria instanceof Stat)) {
                return DataResult.error(() -> criteria.getName() + " is not a stat");
            }
            Stat stat = (Stat)criteria;
            return DataResult.success((Object)stat);
        }).orElseGet(() -> DataResult.error(() -> "Unknown stat " + name)), ObjectiveCriteria::getName);
    }
}

